/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the data model for form entries.
 * @private
 */
Ext.define('Ametys.plugins.forms.tree.FormsTree.FormEntry', {
    extend: 'Ext.data.Model',
    
    fields: [
        'id',
        {name: 'isForm', type: 'boolean'},
        {name: 'hasChildren', type: 'boolean'},
        {name: 'isConfigured', type: 'boolean'},
        {
            name: 'leaf', 
            type: 'boolean',
            convert: function(value, record) {
                var data = record.data;
                if (data.root)
                {
                    return false;
                }
                return !data.hasChildren;
            }
        },
        {
            name: 'text', 
            type: 'string', 
            convert: function(value, record) {
                if (value)
                {
                   return value;
                }
            
                var data = record.data;
                if (data.root)
                {
                   return data.text;
                }
                else if (data.type == "question")
                {
                    return data.title;
                }
                else
                {
                   return data.title;
                }
            }
        },
        {name: 'fullPath', type: 'string'},
        'author',
        {
            name: 'authorFullName', 
            type: 'string',
            calculate: function (data) {
                return data.author ? data.author.sortablename: '';
            }
        },
        'contributor',
        {
            name: 'contributorFullName', 
            type: 'string',
            calculate: function (data) {
                return data.contributor ? data.contributor.sortablename: '';
            }
        },
        'type',
        'questionType',
        {name: 'lastModificationDate', type:'date', dateFormat:'c'},
        {name: 'creationDate', type:'date', dateFormat:'c'},
        {
            name: 'iconCls',
            calculate: function (data)
            {
                 if (data.type == 'root')
                {
                    return 'a-tree-glyph ametysicon-code-html-form';
                }
                else if (data.type == 'page')
                {
                    return 'a-tree-glyph ametysicon-website38';
                }
                else if (data.type == 'question')
                {
                    switch(data.questionType)
                    {
                        case 'form.SimpleText':
                            return 'a-tree-glyph ametysicon-input';
                            
                        case 'form.TextArea':
                            return 'a-tree-glyph ametysicon-text-input';
                            
                        case 'form.Number':
                            return 'a-tree-glyph ametysicon-maths-number-zero-one';
                            
                        case 'form.DateTime':
                            return 'a-tree-glyph ametysicon-datetime-datetime';
                            
                        case 'org.ametys.plugins.forms.question.File':
                            return 'a-tree-glyph ametysicon-file98';
                            
                        case 'form.Computed':
                            return 'a-tree-glyph ametysicon-three115';
                            
                        case 'form.ChoicesList':
                            return 'a-tree-glyph ametysicon-drop-down-list';
                            
                        case 'form.Matrix':
                            return 'a-tree-glyph ametysicon-matrix';
                            
                        case 'form.Checkbox':
                            return 'a-tree-glyph ametysicon-code-html-input-checkbox-on';
                            
                        case 'form.RichText':
                            return 'a-tree-glyph ametysicon-code-css-text-transform';
                    }
                }
                else
                {
                    return 'a-tree-glyph ametysicon-question13';
                }
            }
        }
    ],
    
    getFullPath: function()
    {
        var separator = " > ";
        var fullPath = this.getPath("text", separator);
        var i = fullPath.indexOf(separator, 1);
        return fullPath.substring(i + separator.length);
    }
});