/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms;

import javax.jcr.RepositoryException;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormDirectory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.jackrabbit.util.ISO9075;

public class FormXpathUtils
extends AbstractLogEnabled
implements Component {
    public static String getXPathForFormDirectories(FormDirectory formDirectory) {
        return FormXpathUtils._getXPathQuery(formDirectory, true, ObjectToReturn.FORM_DIRECTORY);
    }

    public static String getXPathForFormPages(Form form, boolean onlyDirectChildren) {
        return FormXpathUtils._getXPathQuery(form, onlyDirectChildren, ObjectToReturn.FORM_PAGE);
    }

    public static String getXPathForForms(FormDirectory formdirectory, boolean onlyDirectChildren) {
        return FormXpathUtils._getXPathQuery(formdirectory, onlyDirectChildren, ObjectToReturn.FORM);
    }

    private static String _getXPathQuery(DefaultTraversableAmetysObject traversableAO, boolean onlyDirectChildren, ObjectToReturn objectToReturn) {
        StringBuilder parentPath = FormXpathUtils._getParentPath(traversableAO);
        String slashOrDoubleSlash = onlyDirectChildren ? "/" : "//";
        StringBuilder query = parentPath.append(slashOrDoubleSlash).append("element(*, ").append(objectToReturn.toNodetype()).append(")");
        return query.toString();
    }

    private static StringBuilder _getParentPath(DefaultTraversableAmetysObject traversableAO) {
        try {
            StringBuilder parentPath = new StringBuilder("/jcr:root").append(ISO9075.encodePath((String)traversableAO.getNode().getPath()));
            return parentPath;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException((Throwable)e);
        }
    }

    private static enum ObjectToReturn {
        FORM,
        FORM_PAGE,
        FORM_DIRECTORY;

        private String _nodetype;

        String toNodetype() {
            return this._nodetype;
        }

        static {
            ObjectToReturn.FORM._nodetype = "ametys:form";
            ObjectToReturn.FORM_DIRECTORY._nodetype = "ametys:forms";
            ObjectToReturn.FORM_PAGE._nodetype = "ametys:form-page";
        }
    }
}

