/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.cache;

import java.util.Set;
import org.ametys.core.right.AllowedUsers;
import org.ametys.core.right.RightManager;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.service.StaticService;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class FormService
extends StaticService {
    protected AmetysObjectResolver _resolver;
    protected RightManager _rightManager;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
    }

    public boolean isCacheable(Page currentPage, ZoneItem zoneItem) {
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        String formId = (String)serviceParameters.getValue("formId");
        Form form = (Form)this._resolver.resolveById(formId);
        return form.isCacheable() && this._isLessRestrictive(form, currentPage);
    }

    private boolean _isLessRestrictive(Form form, Page page) {
        if (this._rightManager.hasAnonymousReadAccess((Object)form)) {
            return true;
        }
        if (this._rightManager.hasAnonymousReadAccess((Object)page)) {
            return false;
        }
        if (this._rightManager.hasAnyConnectedUserReadAccess((Object)form)) {
            return true;
        }
        if (this._rightManager.hasAnyConnectedUserReadAccess((Object)page)) {
            return false;
        }
        AllowedUsers formAllowedUsers = this._rightManager.getReadAccessAllowedUsers((Object)form);
        AllowedUsers pageAllowedUsers = this._rightManager.getReadAccessAllowedUsers((Object)page);
        Set formSet = formAllowedUsers.resolveAllowedUsers(true);
        Set pageSet = pageAllowedUsers.resolveAllowedUsers(true);
        return formSet.containsAll(pageSet);
    }
}

