/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.generators;

import java.io.IOException;
import java.util.Map;
import org.ametys.core.right.RightManager;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.helper.FormStatisticsHelper;
import org.ametys.plugins.forms.question.types.impl.CheckBoxQuestionType;
import org.ametys.plugins.forms.question.types.impl.ChoicesListQuestionType;
import org.ametys.plugins.forms.question.types.impl.MatrixQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SummaryExportGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _resolver;
    protected FormStatisticsHelper _formStatsHelper;
    protected RightManager _rightManager;
    protected FormEntryDAO _formEntryDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._formStatsHelper = (FormStatisticsHelper)((Object)smanager.lookup(FormStatisticsHelper.ROLE));
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
        this._formEntryDAO = (FormEntryDAO)((Object)smanager.lookup(FormEntryDAO.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String formId = (String)request.get("id");
        Form form = (Form)this._resolver.resolveById(formId);
        this.contentHandler.startDocument();
        Map<String, Map<String, Map<String, Object>>> statsMap = this._formStatsHelper.getStatsMap(form);
        AttributesImpl formAttrs = new AttributesImpl();
        formAttrs.addCDATAAttribute("id", form.getId());
        formAttrs.addCDATAAttribute("entries-count", String.valueOf(form.getEntries().size()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"form", (Attributes)formAttrs);
        for (String questionId : statsMap.keySet()) {
            this._saxQuestionStats(form, statsMap, questionId);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"form");
        this.contentHandler.endDocument();
    }

    protected void _saxQuestionStats(Form form, Map<String, Map<String, Map<String, Object>>> statsMap, String questionName) throws SAXException {
        FormQuestion question = form.getQuestion(questionName);
        AttributesImpl questionAttrs = new AttributesImpl();
        questionAttrs.addCDATAAttribute("type", question.getType().getId());
        questionAttrs.addCDATAAttribute("title", question.getTitle());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"question", (Attributes)questionAttrs);
        if (question.getType() instanceof MatrixQuestionType) {
            this._saxMatrixStats(statsMap, question);
        } else if (question.getType() instanceof ChoicesListQuestionType) {
            this._saxChoicesStats(statsMap, questionName);
        } else if (question.getType() instanceof CheckBoxQuestionType) {
            this._saxBooleanStats(statsMap, questionName);
        } else {
            this._saxDefaultQuestionStats(statsMap, questionName);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"question");
    }

    protected void _saxMatrixStats(Map<String, Map<String, Map<String, Object>>> statsMap, FormQuestion question) throws SAXException {
        MatrixQuestionType type = (MatrixQuestionType)question.getType();
        Map<String, Map<String, Object>> rows = statsMap.get(question.getNameForForm());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"values");
        for (String row : rows.keySet()) {
            AttributesImpl rowAttrs = new AttributesImpl();
            rowAttrs.addCDATAAttribute("label", type.getRows(question).get(row));
            rowAttrs.addCDATAAttribute("value", row);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"options", (Attributes)rowAttrs);
            Map<String, Object> columns = rows.get(row);
            for (String col : columns.keySet()) {
                AttributesImpl colsAttrs = new AttributesImpl();
                colsAttrs.addCDATAAttribute("label", type.getColumns(question).get(col));
                colsAttrs.addCDATAAttribute("value", col);
                colsAttrs.addCDATAAttribute("count", String.valueOf(columns.get(col)));
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"option", (Attributes)colsAttrs);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"options");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"values");
    }

    protected void _saxChoicesStats(Map<String, Map<String, Map<String, Object>>> statsMap, String questionName) throws SAXException {
        Map<String, Map<String, Object>> values = statsMap.get(questionName);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"values");
        Map<String, Object> options = values.get("values");
        for (String option : options.keySet()) {
            AttributesImpl optAttrs = new AttributesImpl();
            optAttrs.addCDATAAttribute("label", ((FormStatisticsHelper.Option)options.get(option)).label());
            optAttrs.addCDATAAttribute("count", String.valueOf(((FormStatisticsHelper.Option)options.get(option)).count()));
            optAttrs.addCDATAAttribute("value", option);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"option", (Attributes)optAttrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"values");
    }

    protected void _saxBooleanStats(Map<String, Map<String, Map<String, Object>>> statsMap, String questionName) throws SAXException {
        Map<String, Object> values = statsMap.get(questionName).get("values");
        AttributesImpl boolAttrs = new AttributesImpl();
        boolAttrs.addCDATAAttribute("true", String.valueOf(values.get("true")));
        boolAttrs.addCDATAAttribute("false", String.valueOf(values.get("false")));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"values", (Attributes)boolAttrs);
    }

    protected void _saxDefaultQuestionStats(Map<String, Map<String, Map<String, Object>>> statsMap, String questionName) throws SAXException {
        Map<String, Object> values = statsMap.get(questionName).get("values");
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("answered", String.valueOf(values.get("answered")));
        attrs.addCDATAAttribute("empty", String.valueOf(values.get("empty")));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"values", (Attributes)attrs);
    }
}

