/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ScheduleOpeningHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = ScheduleOpeningHelper.class.getName();
    protected AmetysObjectResolver _resolver;
    protected FormDAO _formDAO;
    protected CurrentUserProvider _currentUserProvider;
    protected ObservationManager _observationManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
    }

    @Callable(rights={""})
    public Map<String, Object> getScheduledDates(String formId) {
        LocalDate endDate;
        HashMap<String, Object> dates = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        LocalDate startDate = form.getStartDate();
        if (startDate != null) {
            dates.put("startDate", DateUtils.localDateToString((LocalDate)startDate));
        }
        if ((endDate = form.getEndDate()) != null) {
            dates.put("endDate", DateUtils.localDateToString((LocalDate)endDate));
        }
        return dates;
    }

    @Callable(rights={""})
    public boolean setScheduledDate(String formId, String startDateAsStr, String endDateAsStr) {
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        LocalDate startDate = startDateAsStr != null ? LocalDate.parse(startDateAsStr) : null;
        LocalDate endDate = endDateAsStr != null ? LocalDate.parse(endDateAsStr) : null;
        form.setStartDate(startDate);
        form.setEndDate(endDate);
        form.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", form);
        this._observationManager.notify(new Event("form.modified", this._currentUserProvider.getUser(), eventParams));
        return true;
    }

    public FormStatus getStatus(Form form) {
        LocalDate startDate = form.getStartDate();
        LocalDate endDate = form.getEndDate();
        LocalDate now = LocalDate.now();
        if (startDate != null && startDate.isAfter(now)) {
            return FormStatus.COMING;
        }
        if (endDate != null && endDate.isBefore(now)) {
            return FormStatus.OVER;
        }
        return FormStatus.OPEN;
    }

    public static enum FormStatus {
        COMING,
        OPEN,
        OVER;

    }
}

