/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.repository;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.plugins.forms.FormAndDirectoryCommonMethods;
import org.ametys.plugins.forms.repository.FormDirectoryFactory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.MovableAmetysObject;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.web.repository.SiteAwareAmetysObject;
import org.ametys.web.repository.site.Site;

public class FormDirectory
extends DefaultTraversableAmetysObject<FormDirectoryFactory>
implements MovableAmetysObject,
SiteAwareAmetysObject {
    public static final String ATTRIBUTE_TITLE = "ametys:title";

    public FormDirectory(Node node, String parentPath, FormDirectoryFactory factory) {
        super(node, parentPath, (DefaultTraversableAmetysObjectFactory)factory);
    }

    public String getTitle() throws AmetysRepositoryException {
        try {
            if (this.getNode().hasProperty(ATTRIBUTE_TITLE)) {
                return this.getNode().getProperty(ATTRIBUTE_TITLE).getString();
            }
            return this.getNode().getName();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get title property", (Throwable)e);
        }
    }

    public void setTitle(String title) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(ATTRIBUTE_TITLE, title);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set title property", (Throwable)e);
        }
    }

    public void moveTo(AmetysObject newParent, boolean renameIfExist) throws AmetysRepositoryException, RepositoryIntegrityViolationException {
        FormAndDirectoryCommonMethods.moveTo(newParent, renameIfExist, (SimpleAmetysObject)this);
    }

    public boolean canMoveTo(AmetysObject newParent) throws AmetysRepositoryException {
        return FormAndDirectoryCommonMethods.canMoveTo(this.getSiteName(), newParent, (SimpleAmetysObject)this, ((FormDirectoryFactory)this._getFactory()).getFormDirectoryDAO());
    }

    public void orderBefore(AmetysObject siblingNode) throws AmetysRepositoryException {
        FormAndDirectoryCommonMethods.orderBefore(siblingNode, (SimpleAmetysObject)this);
    }

    public String getSiteName() throws AmetysRepositoryException {
        return this.getSite().getName();
    }

    public Site getSite() throws AmetysRepositoryException {
        AmetysObject parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Site); parent = parent.getParent()) {
        }
        if (parent == null) {
            throw new AmetysRepositoryException("An error occurred with form with id '" + this.getId() + "'. Form directories must always be linked to a site");
        }
        return (Site)parent;
    }
}

