/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon controller that is able to paste a form
 * @private
 */
Ext.define('Ametys.plugins.forms.controllers.PasteFormElementController', {
	extend: 'Ametys.ribbon.element.ui.ButtonController',
	 
	constructor: function()
	{	
        this.callParent(arguments);
        
		Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
	},
	
	/**
     * Listener on modified message.
     * Update the state of the controller accordingly.
     * @param {Ametys.message.Message} message the message of type modified.
     * @private
     */
	_onModified: function(message)
    {
        message = message || Ametys.message.MessageBus.getCurrentSelectionMessage();
        
        var clipboardTarget = message.getTarget(Ametys.message.MessageTarget.CLIPBOARD); 
        
        if (clipboardTarget != null)
        {
            this.refresh();
        }
    },
    
    updateState: function()
    {
        var clipboardData = Ametys.clipboard.Clipboard.getData();
        if (clipboardData.length > 0 && Ametys.clipboard.Clipboard.getType() == this.getInitialConfig('copied-formelement-id'))
        {
            this.setDescription(Ext.String.format(this.getInitialConfig("copied-formelement-description"), clipboardData[0].title || ''));
            this.enable();
        }
        else
        {
            this.setDescription(this.getInitialConfig("nocopied-formelement-description"));
            this.disable();
        }
    }
});
