/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

var FormListenersHelper = {
    
    inputListeners: {},
    
    /**
     * Add listener of inputs
     * @param {String} uniqueId The uniqueId for the form
     * @param {Function} listener the listener
     */
    addListenerForInputs: function(uniqueId, listener)
    {
        if (!FormListenersHelper.inputListeners[uniqueId])
        {
            FormListenersHelper.inputListeners[uniqueId] = [];
        }
        FormListenersHelper.inputListeners[uniqueId].push(listener);
    },
    
    /**
     * Execute listener of inputs
     * @param {String} uniqueId The uniqueId for the form
     * @param {Integer} pageNumber The page number
     */
    executeListenerForInputs: function(uniqueId, pageNumber)
    {
        if (FormListenersHelper.inputListeners[uniqueId])
        {
            var listeners = FormListenersHelper.inputListeners[uniqueId];
            for (var i in listeners)
            {
                listeners[i](uniqueId, pageNumber);
            }
        }
    }
}
