--
--  Copyright 2021 Anyware Services
--
--  Licensed under the Apache License, Version 2.0 (the "License");
--  you may not use this file except in compliance with the License.
--  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing, software
--  distributed under the License is distributed on an "AS IS" BASIS,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the License for the specific language governing permissions and
--  limitations under the License.
--

DROP SEQUENCE seq_form_session;
DROP TABLE Form_Answer;
DROP TABLE Form_Session;

CREATE TABLE Form_Session (
    sessionId INTEGER NOT NULL,
    formId VARCHAR(64) NOT NULL,
    login VARCHAR(64),
    population VARCHAR(200),
    IPAddress VARCHAR(32),
    submittedAt DATE,
    PRIMARY KEY(sessionId)
);

CREATE TABLE Form_Answer (
    sessionId INTEGER NOT NULL,
    questionId VARCHAR(64) NOT NULL,
    answer CLOB,
    PRIMARY KEY(sessionId, questionId)
);

CREATE SEQUENCE seq_form_session;
