<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:docbook="http://docbook.org/ns/docbook"
	xmlns:html="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
	xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
    xmlns:forms="org.ametys.plugins.forms.xslt.FormsXSLTHelper"
	xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
	xmlns:math="http://exslt.org/math" 
	exclude-result-prefixes="docbook xlink forms resolver ametys html math">

    <xsl:import href="view://stylesheets/utils.xsl"/>
    <xsl:import href="plugin:web://stylesheets/helper/common.xsl"/>
    <xsl:import href="docbook2html-defaultdatesandtimes.xsl"/>
    
    <xsl:variable name="uri-prefix" select="ametys:uriPrefix()"/>
    <xsl:variable name="captchaType" select="ametys:config('runtime.captcha.type')"/>
     
	<!-- + 
	     | FORM
	     + -->
	<xsl:template match="html:form">
	    <xsl:variable name="id" select="concat('form', substring-after(math:random(), '.'))"/>
          <script type="text/javascript" src="{ametys:pluginResourceURL('forms', 'js/FormsHelper.js')}"></script>
          
          <script type="text/javascript">
			function checkForm_<xsl:value-of select="translate(@id, '-', '_')"/>()
			{
				return checkForm("<xsl:value-of select="translate(@id, '-', '_')"/>", 
                                 "<xsl:value-of select="$id"/>", 
                                 function(reset, error) {
                    // checking form informations
                    <xsl:apply-templates mode="form-check"/>
                 });
			}
            
            function alertNotAvailable_<xsl:value-of select="translate(@id, '-', '_')"/>()
            {
                parent.Ext.Msg.alert("<i18n:text i18n:key='PLUGINS_FORMS_FORMS_VALIDATE_DISABLED_BACK_TITLE' i18n:catalogue='plugin.forms'/>",
                                       "<i18n:text i18n:key='PLUGINS_FORMS_FORMS_VALIDATE_DISABLED_BACK_MESSAGE' i18n:catalogue='plugin.forms'/>");
                return false;
            }
		</script>
		<form method="post" id="{$id}">
			<xsl:copy-of select="@class"/>
            
            <xsl:if test="descendant::html:input[@type = 'file']">
                <xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
            </xsl:if>
			
			<xsl:attribute name="action">
                <xsl:choose>
                    <xsl:when test="@type='cms'"><xsl:value-of select="$uri-prefix"/>/plugins/forms/submit.html</xsl:when>
                    <xsl:otherwise><xsl:value-of select="forms:decode(@action)"/></xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:choose>
                <xsl:when test="$rendering-context='back' or $rendering-context=''">
                    <xsl:attribute name="onsubmit"> return alertNotAvailable_<xsl:value-of select="translate(@id, '-', '_')"/>();</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="onsubmit"> return checkForm_<xsl:value-of select="translate(@id, '-', '_')"/>();</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            
            <xsl:call-template name="handle-limit">
                <xsl:with-param name="id" select="$id"/>
            </xsl:call-template>
            
			<div data-ametys-form="form">
				<xsl:if test="@type='cms'">
                    <input type="hidden" name="ametys-form-id" value="{@id}"/>
					<input type="hidden" name="ametys-content-id" value="{/view/content/@id}"/>
				</xsl:if>
				
				<xsl:if test="@target or ($rendering-context='back' or $rendering-context='')">
					<script type="text/javascript">
					    $j('#<xsl:value-of select="$id"/>').prop('target', "_blank");
					</script>
				</xsl:if>
		
				<xsl:apply-templates />
			</div>
		</form>
        <xsl:call-template name="form-cost">
            <xsl:with-param name="id" select="$id"/>
        </xsl:call-template>
	</xsl:template>
    
    <xsl:template name="form-cost">
        <xsl:param name="id"/>
        <script>
            computeFormCost($j("#<xsl:value-of select='$id'/> > *")[0]); // Do it now to avoid blinking if the page is long to load
            $j(document).ready(function () {
                computeFormCost($j("#<xsl:value-of select='$id'/> > *")[0]); // Do it on load to handle 'back' brwoser after submit
            });
        </script>
    </xsl:template>
    
    <xsl:template name="handle-limit">
        <xsl:param name="id"/>
        
        <xsl:if test="@limit">
            <xsl:attribute name="data-ametys-form-state">loading</xsl:attribute>

            <script type="text/javascript">
                callURL("<xsl:value-of select="translate(@id, '-', '_')"/>", "<xsl:value-of select="$id"/>", "<xsl:value-of select="@limit"/>", "<xsl:value-of select="$uri-prefix"/>/plugins/")
            </script>
    
            <div class="form-limit-loading"></div>
            <p data-ametys-form-fill="starterror-text">
                <i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR" i18n:catalogue="plugin.forms"/>
            </p>
            <xsl:if test="@no_places != ''">
                <p data-ametys-form-fill="closed-text">
                    <xsl:value-of select="@no_places"/>
                </p>
            </xsl:if>
            <xsl:if test="@places != ''">
                <p data-ametys-form-fill="limit-text">
                    <xsl:value-of select="@places"/>
                </p>
            </xsl:if>
        </xsl:if>
    </xsl:template>

	<!-- + 
	     | LABEL
	     + -->
	<xsl:template match="html:label">
		<div class="label">
			<xsl:variable name="for" select="@for"/>
			<xsl:variable name="input" select="//html:*[(local-name(.) = 'input' or local-name(.) = 'select' or local-name(.) = 'textarea' or local-name(.) = 'captcha') and @id = $for]"/>
			
			<label for="{@for}" id="{@for}_label">
				<xsl:value-of select="." />
				
				<xsl:call-template name="form-label-description">
					<xsl:with-param name="description" select="$input/@description"/>
				</xsl:call-template>
			
				<xsl:if test="$input[@mandatory = 'true' or local-name(.) = 'captcha']">
					<xsl:variable name="name" select="$input/@name"/>
					<xsl:variable name="type" select="$input/@type"/>
				
					<xsl:if test="$input[@type != 'radio'] or (count($input/preceding::html:input[@type = $type and @name = $name]) = 0 and not(ancestor::html:fieldset[html:legend and not(.//html:select) and not(.//html:textarea) and not(.//html:captcha) and not(.//html:input[@type != 'radio']) and not(.//html:input[@mandatory != 'true'])]))">
						<span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
					</xsl:if>
				</xsl:if>
                
                <xsl:call-template name="form-label-additionnal">
                    <xsl:with-param name="input" select="$input"/>
                </xsl:call-template>
			</label>
		</div>
	</xsl:template>
    
    <xsl:template match="html:form//docbook:para">
        <div>
            <xsl:call-template name="get-styles"/>
            <xsl:apply-templates/>
        </div>
    </xsl:template>

	<!-- +
	     | INPUT SUBMIT
	     + -->
	<xsl:template match="html:input[@type='submit' or @type='reset']">
		<xsl:call-template name="common-utils-input-submit">
			<xsl:with-param name="text" select="@value"/>
			<xsl:with-param name="name" select="@name"/>
			<xsl:with-param name="id" select="@id"/>
			<xsl:with-param name="type" select="@type"/>
			<xsl:with-param name="width" select="@width"/>
		</xsl:call-template>
	</xsl:template>

	<!-- + 
	     | INPUT
	     + -->
	<xsl:template match="html:input">
		<div>
			<xsl:if test="@width">
				<xsl:attribute name="style">width: <xsl:value-of select="@width"/>px;</xsl:attribute>
			</xsl:if>
            <xsl:apply-templates select="." mode="class-attribute"/>
		
			<xsl:call-template name="form-input"/>	
			<xsl:if test="@autofill and @autofill != '' and @autofill != 'none'">
				<xsl:call-template name="fill-user-input-js">
	                <xsl:with-param name="id" select="@id"/>
	                <xsl:with-param name="field" select="@autofill"/>
	            </xsl:call-template>
			</xsl:if>
		</div>
		
		<xsl:call-template name="form-input-description"/>
		<div class="field-end"/>
		
        <xsl:call-template name="form-input-additionnal"/>
        
		<xsl:call-template name="form-input-confirmation"/>
	</xsl:template>
    
    <xsl:template match="html:input" mode="class-attribute">
        <xsl:attribute name="class">
            <xsl:text>input</xsl:text>
            <xsl:choose>
                <xsl:when test="@type = 'text' and @regexptype = 'date'"> input-date</xsl:when>
                <xsl:when test="@type = 'text' and @regexptype = 'datetime'"> input-datetime</xsl:when>
                <xsl:when test="@type = 'text' and @regexptype = 'time'"> input-time</xsl:when>
                <xsl:otherwise> input-<xsl:value-of select="@type"/></xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>

	<xsl:template name="form-input">
		<input>
			<xsl:copy-of select="@id" />
			<xsl:copy-of select="@name" />
			<xsl:copy-of select="@type" />
			<xsl:copy-of select="@value" />
            <xsl:copy-of select="@placeholder" />
			
			<xsl:if test="@width">
				<xsl:attribute name="style">width: <xsl:value-of select="@width"/>px;</xsl:attribute>
			</xsl:if>
			
			<xsl:if test="@width and @type='file'">
				<!-- for input type=file were width may no apply -->
				<xsl:attribute name="size">
					<xsl:variable name="shouldbe" select="ceiling((number(@width) - 104) div 6)"/>
					<xsl:choose>
						<xsl:when test="$shouldbe &lt; 1"><xsl:text>1</xsl:text></xsl:when>
						<xsl:otherwise><xsl:value-of select="$shouldbe"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</xsl:if>
			
			<xsl:if test="@checked = 'true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
			<xsl:if test="@maxvalue and (@type = 'password' or (@type = 'text' and (@regexptype = '' or @regexptype = 'text' or @regexptype = 'email' or @regexptype = 'phone' or @regexptype = 'custom')))"><xsl:attribute name="maxlength"><xsl:value-of select="@maxvalue"/></xsl:attribute></xsl:if>
            <xsl:call-template name="form-input-time"/>
            <xsl:call-template name="form-input-date"/>
            <xsl:call-template name="form-input-datetime"/>
            
            <xsl:if test="@type = 'cost'">
                <xsl:attribute name="type">text</xsl:attribute>
                <xsl:attribute name="readonly">readonly</xsl:attribute>
                <xsl:attribute name="data-unit"><xsl:choose><xsl:when test="@unitcost"><xsl:value-of select="@unitcost"/></xsl:when><xsl:otherwise>EUR</xsl:otherwise></xsl:choose></xsl:attribute>
                <xsl:attribute name="data-lang"><xsl:value-of select="ametys:lang()"/></xsl:attribute>
            </xsl:if>
		</input>
	</xsl:template>
    
	<xsl:template name="form-label-description">
		<xsl:param name="description" select="@description"/>
		
		<xsl:call-template name="form-field-description">
			<xsl:with-param name="description" select="$description"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="form-input-description">
		<xsl:param name="description" select="@description"/>
	</xsl:template>
	
	<xsl:template name="form-field-description">
		<xsl:param name="description"/>
		
		<xsl:if test="$description and $description != ''">
			<span class="input-help" title="{escape:unescapeHtml($description)}"><span><i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_INPUT_HELP" i18n:catalogue="plugin.forms"/></span></span>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="form-input-confirmation">
		<xsl:if test="@confirmation = 'true'">
			<div class="input">
				<xsl:attribute name="style">margin-top: 5px; <xsl:if test="@width">width: <xsl:value-of select="@width"/>px;</xsl:if></xsl:attribute>

				<input name="{@name}_confirmation" id="{@id}_confirmation">
					<xsl:copy-of select="@type" />
					<xsl:copy-of select="@value" />
					
					<xsl:if test="@width and @type='file'">
						<!-- for input type=file were width may no apply -->
						<xsl:attribute name="size">
							<xsl:variable name="shouldbe" select="ceiling((number(@width) - 104) div 6)"/>
							<xsl:choose>
								<xsl:when test="$shouldbe &lt; 1"><xsl:text>1</xsl:text></xsl:when>
								<xsl:otherwise><xsl:value-of select="$shouldbe"/></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</xsl:if>
					
					<xsl:attribute name="style"><xsl:if test="@width">width: <xsl:value-of select="@width"/>px;</xsl:if></xsl:attribute>
			
					<xsl:if test="@checked = 'true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
					<xsl:if test="@maxvalue and (@type = 'password' or (@type = 'text' and (@regexptype = '' or @regexptype = 'text' or @regexptype = 'email' or @regexptype = 'phone' or @regexptype = 'custom')))"><xsl:attribute name="maxlength"><xsl:value-of select="@maxvalue"/></xsl:attribute></xsl:if>
                    <xsl:call-template name="form-input-time"/>
                    <xsl:call-template name="form-input-date"/>
                    <xsl:call-template name="form-input-datetime"/>
                </input>
			</div>
			<div class="field-end"/>
		</xsl:if>
	</xsl:template>
    
	<xsl:template match="html:input[@type='text']" mode="form-check">
        <xsl:variable name="valueId" select="translate(@id, '-', '_')"/>
		reset("<xsl:value-of select="@id"/>", "<xsl:value-of select="@type"/>");
		<xsl:if test="@mandatory = 'true'">
			if ($j("#<xsl:value-of select="@id"/>").prop('value') == '')
			{
				error("<xsl:value-of select="@id"/>", "text", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_MANDATORY" i18n:catalogue="plugin.forms"/>");
			}
		</xsl:if>
		<xsl:if test="@confirmation = 'true'">
			if ($j("#<xsl:value-of select="@id"/>").prop('value') != $j("#<xsl:value-of select="@id"/>_confirmation").prop('value'))
			{
				error("<xsl:value-of select="@id"/>", "text", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_CONFIRMATION" i18n:catalogue="plugin.forms"/>");
			} 
		</xsl:if>

		var value_<xsl:value-of select="$valueId"/> = $j("#<xsl:value-of select="@id"/>").prop('value');
		<xsl:choose>
			<xsl:when test="not(@regexptype) or @regexptype = '' or @regexptype = 'text'">
				<xsl:if test="@minvalue and @minvalue != ''">
					if (value_<xsl:value-of select="$valueId"/> != '' &amp;&amp; value_<xsl:value-of select="$valueId"/>.length &lt; <xsl:value-of select="@minvalue"/>)
					{
						error("<xsl:value-of select="@id"/>", "text", "<i18n:translate><i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_MINLENGTH" i18n:catalogue="plugin.forms"/><i18n:param><xsl:value-of select="@minvalue"/></i18n:param></i18n:translate>");
					}
				</xsl:if>
			</xsl:when>
			<xsl:when test="@regexptype = 'int'">
				if (value_<xsl:value-of select="$valueId"/> != '')
				{
					if (!/^-?[0-9]+$/.test(value_<xsl:value-of select="$valueId"/>))
					{
						error("<xsl:value-of select="@id"/>", "text", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_INTEGER" i18n:catalogue="plugin.forms"/>");
					}
					else
					{
						<xsl:if test="@minvalue and @minvalue != ''">
							if (parseInt(value_<xsl:value-of select="$valueId"/>) &lt; <xsl:value-of select="@minvalue"/>)
							{
								error("<xsl:value-of select="@id"/>", "text", "<i18n:translate><i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_INTEGER_MINVALUE" i18n:catalogue="plugin.forms"/><i18n:param><xsl:value-of select="@minvalue"/></i18n:param></i18n:translate>");
							}	
						</xsl:if>
						<xsl:if test="@maxvalue and @maxvalue != ''">
							if (parseInt(value_<xsl:value-of select="$valueId"/>) &gt; <xsl:value-of select="@maxvalue"/>)
							{
								error("<xsl:value-of select="@id"/>", "text", "<i18n:translate><i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_INTEGER_MAXVALUE" i18n:catalogue="plugin.forms"/><i18n:param><xsl:value-of select="@maxvalue"/></i18n:param></i18n:translate>");
							}	
						</xsl:if>
					}
				}
			</xsl:when>
			<xsl:when test="@regexptype = 'float'">
				if (value_<xsl:value-of select="$valueId"/> != '')
				{
					if (!/^-?[0-9]+(\.[0-9]+)?$/.test(value_<xsl:value-of select="$valueId"/>))
					{
						error("<xsl:value-of select="@id"/>", "text", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_FLOAT" i18n:catalogue="plugin.forms"/>");
					}
					else
					{
						<xsl:if test="@minvalue and @minvalue != ''">
							if (parseFloat(value_<xsl:value-of select="$valueId"/>) &lt; <xsl:value-of select="@minvalue"/>)
							{
								error("<xsl:value-of select="@id"/>", "text", "<i18n:translate><i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_FLOAT_MINVALUE" i18n:catalogue="plugin.forms"/><i18n:param><xsl:value-of select="@minvalue"/></i18n:param></i18n:translate>");
							}	
						</xsl:if>
						<xsl:if test="@maxvalue and @maxvalue != ''">
							if (parseFloat(value_<xsl:value-of select="$valueId"/>) &gt; <xsl:value-of select="@maxvalue"/>)
							{
								error("<xsl:value-of select="@id"/>", "text", "<i18n:translate><i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_FLOAT_MAXVALUE" i18n:catalogue="plugin.forms"/><i18n:param><xsl:value-of select="@maxvalue"/></i18n:param></i18n:translate>");
							}	
						</xsl:if>
					}
				}
			</xsl:when>
			<xsl:when test="@regexptype = 'email'">
				if (value_<xsl:value-of select="$valueId"/> != '' &amp;&amp; !/^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,})+$/.test(value_<xsl:value-of select="$valueId"/>))
				{
					error("<xsl:value-of select="@id"/>", "text", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_EMAIL" i18n:catalogue="plugin.forms"/>");
				}
			</xsl:when>
			<xsl:when test="@regexptype = 'phone'">
				if (value_<xsl:value-of select="$valueId"/> != '' &amp;&amp; !/^(\+?\(?[0-9]{1,3}\)?([\s]?)(\(0\))?|0)([\s]?)([0-9\-\+\s]{4,})+$/.test(value_<xsl:value-of select="$valueId"/>))
				{
					error("<xsl:value-of select="@id"/>", "text", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_PHONE" i18n:catalogue="plugin.forms"/>");
				}
			</xsl:when>
            <xsl:when test="@regexptype = 'date'">
                <xsl:call-template name="form-check-date"><xsl:with-param name="valueId" select="$valueId"/></xsl:call-template>
            </xsl:when>
            <xsl:when test="@regexptype = 'datetime'">
                <xsl:call-template name="form-check-datetime"><xsl:with-param name="valueId" select="$valueId"/></xsl:call-template>
            </xsl:when>
			<xsl:when test="@regexptype = 'time'">
                <xsl:call-template name="form-check-time"><xsl:with-param name="valueId" select="$valueId"/></xsl:call-template>
			</xsl:when>
			<xsl:when test="@regexptype = 'custom'">
				<xsl:if test="@minvalue and @minvalue != ''">
					if (value_<xsl:value-of select="$valueId"/> != '' &amp;&amp; value_<xsl:value-of select="$valueId"/>.length &lt; <xsl:value-of select="@minvalue"/>)
					{
						error("<xsl:value-of select="@id"/>", "text", "<i18n:translate><i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_MINLENGTH" i18n:catalogue="plugin.forms"/><i18n:param><xsl:value-of select="@minvalue"/></i18n:param></i18n:translate>");
					}
				</xsl:if>
				<xsl:if test="@regexp and @regexp != ''">
					if (!<xsl:value-of select="forms:decode(@regexp)"/>.test(value_<xsl:value-of select="$valueId"/>))
					{
						error("<xsl:value-of select="@id"/>", "text", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_REGEXP" i18n:catalogue="plugin.forms"/>");
					}
				</xsl:if>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
    
	<xsl:template match="html:input[@type='password']" mode="form-check">
		reset("<xsl:value-of select="@id"/>", "<xsl:value-of select="@type"/>");
		<xsl:if test="@mandatory = 'true'">
			if ($j("#<xsl:value-of select="@id"/>").prop('value') == '')
			{
				error("<xsl:value-of select="@id"/>", "password", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_PASSWORD_MANDATORY" i18n:catalogue="plugin.forms"/>");
			}
		</xsl:if>
		<xsl:if test="@confirmation = 'true'">
			if ($j("#<xsl:value-of select="@id"/>").prop('value') != $j("#<xsl:value-of select="@id"/>_confirmation").prop('value'))
			{
				error("<xsl:value-of select="@id"/>", "password", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_PASSWORD_CONFIRMATION" i18n:catalogue="plugin.forms"/>");
			} 
		</xsl:if>
		<xsl:if test="@minvalue and @minvalue != ''">
			if ($j("#<xsl:value-of select="@id"/>").prop('value') != '' &amp;&amp; $j("#<xsl:value-of select="@id"/>").prop('value').length &lt; <xsl:value-of select="@minvalue"/>)
			{
				error("<xsl:value-of select="@id"/>", "password", "<i18n:translate><i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_PASSWORD_MINLENGTH" i18n:catalogue="plugin.forms"/><i18n:param><xsl:value-of select="@minvalue"/></i18n:param></i18n:translate>");
			}
		</xsl:if>
		<xsl:if test="@regexp and @regexp != ''">
			if (!<xsl:value-of select="forms:decode(@regexp)"/>.test($j("#<xsl:value-of select="@id"/>").prop('value')))
			{
				error("<xsl:value-of select="@id"/>", "password", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_PASSWORD_REGEXP" i18n:catalogue="plugin.forms"/>");
			}
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="html:input[@type='checkbox']" mode="form-check">
		reset("<xsl:value-of select="@id"/>", "<xsl:value-of select="@type"/>");
		<xsl:if test="@mandatory = 'true'">
			if (!$j("#<xsl:value-of select="@id"/>").prop('checked'))
			{
				error("<xsl:value-of select="@id"/>", "checkbox", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_CHECKBOX_MANDATORY" i18n:catalogue="plugin.forms"/>");
			}
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="html:input[@type='radio']" mode="form-check">
		reset("<xsl:value-of select="@id"/>", "<xsl:value-of select="@type"/>");
		<xsl:variable name="name" select="@name"/>
		<xsl:if test="ancestor::html:form//html:input[@type='radio' and @name=$name and @mandatory = 'true'] and generate-id(ancestor::html:form//html:input[@type='radio' and @name=$name]) = generate-id(.)">
			if (<xsl:text/>
				<xsl:for-each select="ancestor::html:form//html:input[@type='radio' and @name=$name]">
					<xsl:if test="position() != 1"><xsl:text> &amp;&amp; </xsl:text></xsl:if>
					<xsl:text/>!$j("#<xsl:value-of select="@id"/>").prop('checked')<xsl:text/>
				</xsl:for-each>
			   <xsl:text/>)
			{
				error("<xsl:value-of select="@id"/>", "radio", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_RADIO_MANDATORY" i18n:catalogue="plugin.forms"/>");
			}
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="form-check-file-buildextensions">
		<xsl:param name="extensions"/>
		<xsl:param name="first"/>
		
		<xsl:variable name="space"><xsl:choose><xsl:when test="substring-before($extensions, ' ') = ''"><xsl:value-of select="$extensions"/></xsl:when><xsl:otherwise><xsl:value-of select="substring-before($extensions, ' ')"/></xsl:otherwise></xsl:choose></xsl:variable>
		<xsl:variable name="comma"><xsl:choose><xsl:when test="substring-before($extensions, ',') = ''"><xsl:value-of select="$extensions"/></xsl:when><xsl:otherwise><xsl:value-of select="substring-before($extensions, ',')"/></xsl:otherwise></xsl:choose></xsl:variable>
		<xsl:variable name="semicolon"><xsl:choose><xsl:when test="substring-before($extensions, ';') = ''"><xsl:value-of select="$extensions"/></xsl:when><xsl:otherwise><xsl:value-of select="substring-before($extensions, ';')"/></xsl:otherwise></xsl:choose></xsl:variable>
		
		<xsl:variable name="value"><xsl:choose>
			<xsl:when test="string-length($space) &lt; string-length($comma) and string-length($space) &lt; string-length($semicolon)"><xsl:value-of select="$space"/></xsl:when>
			<xsl:when test="string-length($comma) &lt; string-length($space) and string-length($comma) &lt; string-length($semicolon)"><xsl:value-of select="$comma"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$semicolon"/></xsl:otherwise>
		</xsl:choose></xsl:variable>

		<xsl:if test="$value != ''">		
			<xsl:if test="not($first)"><xsl:text/>, </xsl:if>
			<xsl:text/>"<xsl:value-of select="$value"/>"<xsl:text/>

			<xsl:variable name="end" select="substring-after($extensions, $value)"/>
			<xsl:variable name="endSpaces" select="substring-before($end, '.')"/>
			<xsl:variable name="endClean" select="substring($end, 1 + string-length($endSpaces))"/>

			<xsl:if test="string-length($endClean) &gt; 0">
				<xsl:call-template name="form-check-file-buildextensions">
					<xsl:with-param name="extensions" select="$endClean"/>
					<xsl:with-param name="first" select="false()"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template match="html:input[@type='file']" mode="form-check">
		reset("<xsl:value-of select="@id"/>", "<xsl:value-of select="@type"/>");
		<xsl:if test="@mandatory = 'true'">
			if ($j("#<xsl:value-of select="@id"/>").prop('value') == '')
			{
				error("<xsl:value-of select="@id"/>", "file", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_MANDATORY" i18n:catalogue="plugin.forms"/>");
			}
		</xsl:if>

		<xsl:if test="@fileextension">
			var authorized_extensions_<xsl:value-of select="translate(@id, '-', '_')"/> = [<xsl:call-template name="form-check-file-buildextensions"><xsl:with-param name="extensions" select="@fileextension"/><xsl:with-param name="first" select="true()"/></xsl:call-template>];
			
			var file_<xsl:value-of select="translate(@id, '-', '_')"/> = $j("#<xsl:value-of select="@id"/>").prop('value');
			var file_extension_<xsl:value-of select="translate(@id, '-', '_')"/> = file_<xsl:value-of select="translate(@id, '-', '_')"/>.substring(file_<xsl:value-of select="translate(@id, '-', '_')"/>.lastIndexOf("."));

			var isGood_<xsl:value-of select="translate(@id, '-', '_')"/> = file_extension_<xsl:value-of select="translate(@id, '-', '_')"/> == '' || authorized_extensions_<xsl:value-of select="translate(@id, '-', '_')"/>.length == 0;
			for (var i = 0; !isGood_<xsl:value-of select="translate(@id, '-', '_')"/> &amp;&amp; i &lt; authorized_extensions_<xsl:value-of select="translate(@id, '-', '_')"/>.length; i++)
			{
				if (file_extension_<xsl:value-of select="translate(@id, '-', '_')"/>.toLowerCase() == authorized_extensions_<xsl:value-of select="translate(@id, '-', '_')"/>[i].toLowerCase())
				{
					isGood_<xsl:value-of select="translate(@id, '-', '_')"/> = true;
				} 
			}
			
			if (!isGood_<xsl:value-of select="translate(@id, '-', '_')"/>)
			{
				error("<xsl:value-of select="@id"/>", "file", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_EXTENSION" i18n:catalogue="plugin.forms"/> (" + "<xsl:value-of select="@fileextension"/>".replace(/,/g, ' ').replace(/;/g, ' ').replace(/ +/g, ', ') + ")");
			}
		</xsl:if>
	</xsl:template>
	
	<!-- + 
	     | TEXTAREA
	     + -->
	<xsl:template match="html:textarea">
		<div>
			<xsl:attribute name="style">
				<xsl:if test="@width">width: <xsl:value-of select="@width"/>px;</xsl:if>
			</xsl:attribute>
			<xsl:apply-templates select="." mode="class-attribute"/>
            
			<textarea cols="10" rows="3">
				<xsl:attribute name="style">width: <xsl:value-of select="@width"/>px;<xsl:if test="@height">height: <xsl:value-of select="@height"/>px;</xsl:if></xsl:attribute>
				
				<xsl:copy-of select="@id" />
				<xsl:copy-of select="@name" />
                <xsl:copy-of select="@placeholder" />
			
				<xsl:value-of select="forms:decode(.)" />
			</textarea>
		</div>
		<div class="field-end"/>
	</xsl:template>

    <xsl:template match="html:textarea" mode="class-attribute">
        <xsl:attribute name="class">input input-textarea</xsl:attribute>
    </xsl:template> 
    
	<xsl:template match="html:textarea" mode="form-check">
		reset("<xsl:value-of select="@id"/>", "textarea");
		<xsl:if test="@mandatory = 'true'">
			if (/^\s*$/.test($j("#<xsl:value-of select="@id"/>").prop('value')))
			{
				error("<xsl:value-of select="@id"/>", "textarea", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXTAREA_MANDATORY" i18n:catalogue="plugin.forms"/>");
			}
		</xsl:if>
	</xsl:template>

	<!-- + 
	     | SELECT
	     + -->
	<xsl:template match="html:select">
		<div>
			<xsl:attribute name="style">
				<xsl:if test="@width">width: <xsl:value-of select="@width"/>px;</xsl:if>
			</xsl:attribute>
            <xsl:apply-templates select="." mode="class-attribute"/>

			<select>
				<xsl:copy-of select="@id" />
				<xsl:copy-of select="@name" />
	
				<xsl:attribute name="style">width: <xsl:value-of select="@width"/>px;<xsl:if test="@height and @multiple='true'">height: <xsl:value-of select="@height"/>px;</xsl:if></xsl:attribute>
				<xsl:if test="@multiple = 'true'"><xsl:attribute name="multiple">multiple</xsl:attribute></xsl:if>
				
                <xsl:if test="@partofcost='true'">
                    <xsl:attribute name="data-partofcost">true</xsl:attribute>
                    <xsl:attribute name="onchange">computeFormCost(this)</xsl:attribute>
                </xsl:if>
				
                <xsl:if test="@placeholder != '' and @multiple = 'false'">
                    <option selected="selected" disabled="disabled"><xsl:value-of select="@placeholder"/></option>
                </xsl:if>
                
				<xsl:if test="@multiple = 'false' and @mandatory = 'false'"><option>&#160;</option></xsl:if>
                
				<xsl:apply-templates select="html:option" />
			</select>
		</div>
		<div class="field-end"/>
	</xsl:template>
    
    
    <xsl:template match="html:select" mode="class-attribute">
        <xsl:attribute name="class">input input-select</xsl:attribute>
    </xsl:template>

	<xsl:template match="html:select" mode="form-check">
		reset("<xsl:value-of select="@id"/>", "select");
		<xsl:if test="@mandatory = 'true'">
			var select_<xsl:value-of select="translate(@id, '-', '_')"/> = document.getElementById("<xsl:value-of select="@id"/>");
			for (var i = 0; select_<xsl:value-of select="translate(@id, '-', '_')"/> != null &amp;&amp; i &lt; select_<xsl:value-of select="translate(@id, '-', '_')"/>.childNodes.length; i++)
			{
				if (select_<xsl:value-of select="translate(@id, '-', '_')"/>.childNodes[i].selected)
				{
					select_<xsl:value-of select="translate(@id, '-', '_')"/> = null;	
				}
			}
			if (select_<xsl:value-of select="translate(@id, '-', '_')"/> != null)
			{
				error("<xsl:value-of select="@id"/>", "select", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_SELECT_MANDATORY" i18n:catalogue="plugin.forms"/>");
			}
		</xsl:if>
	</xsl:template>

	<xsl:template match="html:option">
		<option>
			<xsl:copy-of select="@value" />
            <xsl:if test="../@partofcost='true' and @cost"><xsl:attribute name="data-cost"><xsl:value-of select="@cost"/></xsl:attribute></xsl:if>
			
			<xsl:value-of select="." />
		</option>
	</xsl:template>

	<!-- + 
	     | FIELDSET
	     + -->
	<xsl:template match="html:fieldset">
		<xsl:element name="fieldset">
			<xsl:apply-templates />
		</xsl:element>
	</xsl:template>

	<xsl:template match="html:legend">
		<legend>
			<xsl:value-of select="." />

            <xsl:if test="not(..//html:select) and not(..//html:textarea) and not(..//html:captcha) and not(..//html:input[@type != 'radio']) and not(..//html:input[@mandatory != 'true'])"> 
                        <span class="mandatory-marker"><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span>
            </xsl:if>		
        </legend>
	</xsl:template>
	
	<!-- + 
	     | CAPTCHA
	     + -->
	<xsl:template match="html:captcha">
		<xsl:variable name="name" select="concat(/view/content/@id, '%20', ancestor::html:form/@id, '%20', @id)"/>
		
		<div class="input" style="width: {@width}px">
			<xsl:call-template name="captcha">
				<xsl:with-param name="key-name" select="concat($name, '-key')"/>
				<xsl:with-param name="key-id" select="concat(@id, '-key')"/>
	
                <xsl:with-param name="placeholder" select="@placeholder"/>
                
				<xsl:with-param name="value-name" select="$name"/>
				<xsl:with-param name="value-id" select="@id"/>
				<xsl:with-param name="value-style">float: left; width: <xsl:value-of select="@width"/>px;</xsl:with-param>
				<xsl:with-param name="value-class"/>
	
				<xsl:with-param name="image-alt"/>
				<xsl:with-param name="image-alt-i18n" select="false()"/>
				<xsl:with-param name="image-style">float: left; margin: 3px 0px 3px 10px; min-width: 100px; width: <xsl:value-of select="number(@width) - 42"/>px; height: <xsl:value-of select="@height"/>px;</xsl:with-param>
				<xsl:with-param name="image-class"/>
				
				<xsl:with-param name="contextPath"><xsl:value-of select="$uri-prefix"/></xsl:with-param>
			</xsl:call-template>
		</div> 
		<div class="field-end"/>
	</xsl:template>
	
	<xsl:template match="html:captcha" mode="form-check">
        <xsl:if test="$captchaType = 'jcaptcha'">
            reset("<xsl:value-of select="@id"/>", "captcha");
            if (!/^[a-z]{6}$/.test($j("#<xsl:value-of select="@id"/>").prop('value')))
            {
                error("<xsl:value-of select="@id"/>", "captcha", "<i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_ERROR_CAPTCHA" i18n:catalogue="plugin.forms"/>");
            }
    </xsl:if>
	</xsl:template>
	
	<xsl:template match="node()" mode="form-check">
		<xsl:apply-templates mode="form-check"/>
	</xsl:template>
</xsl:stylesheet>
