<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="view:forms://stylesheets/forms/helper/entry-information.xsl"/>
    
    <xsl:param name="site-title" />
    <xsl:param name="site-url" />
    <xsl:param name="form-name" />
    
    <xsl:variable name="nl"><xsl:text>
</xsl:text></xsl:variable>
    
    <xsl:template match="field[@type='file']" mode="value">
        <xsl:value-of select="value/@filename" />
    </xsl:template>
    
    <xsl:template match="/">
        <xsl:variable name="date-time-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_MAIL_RESULTS_DATE_TIME_FORMAT')"></xsl:variable>
        <xsl:choose>
            <xsl:when test="entry/@user">
                <i18n:translate>
                    <i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_TEXT_NO_HTML_WITH_USER" i18n:catalogue="plugin.forms"/>
                    <i18n:param><xsl:value-of select="$form-name"/></i18n:param>
                    <i18n:param><i18n:date-time src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="{$date-time-format}"><xsl:value-of select="entry/@creationDate"/></i18n:date-time></i18n:param>
                    <i18n:param><xsl:value-of select="entry/@user"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_TEXT_NO_HTML" i18n:catalogue="plugin.forms"/>
                    <i18n:param><xsl:value-of select="$form-name"/></i18n:param>
                    <i18n:param><i18n:date-time src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="{$date-time-format}"><xsl:value-of select="entry/@creationDate"/></i18n:date-time></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
        
        <xsl:value-of select="concat($nl, $nl)"/>
        <xsl:for-each select="entry/field">
            <xsl:text>* </xsl:text>
            <xsl:value-of select="@label"/>
            <xsl:text>: </xsl:text>
            <xsl:apply-templates select="." mode="display-value"/>
         
            <xsl:if test="position() != last()"><xsl:value-of select="concat($nl, $nl)"/></xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="field" mode="display-value">
        <xsl:choose>
            <xsl:when test="value">
                <xsl:apply-templates select="." mode="value"/>    
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_NO_VALUE" i18n:catalogue="plugin.forms"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="field[@typeId='form.ChoicesList']" mode="display-value">
        <xsl:choose>
            <xsl:when test="additional-infos/values/value">
                <xsl:apply-templates select="." mode="value"/>    
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_NO_VALUE" i18n:catalogue="plugin.forms"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
