<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    exclude-result-prefixes="docbook">
    
    <xsl:param name="mode"/>
    
    <xsl:variable name="nl"><xsl:text>
</xsl:text></xsl:variable>

    <xsl:template match="/">
        <xsl:choose>
            <xsl:when test="$mode = 'text'">
                <xsl:apply-templates select="form-results/entry" mode="text"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="form-results/entry" mode="html"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="entry" mode="text">
        <xsl:text>* </xsl:text>
        <xsl:choose>
            <xsl:when test="normalize-space(@label) != ''">
                <xsl:value-of select="@label"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="@name"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text>: </xsl:text>
        <xsl:choose>
            <xsl:when test="@type = 'CHECKBOX'">
                <xsl:choose>
                    <xsl:when test="text() = 'true'">
                        <i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_TRUE"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_FALSE"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="normalize-space(.) != ''">
                <xsl:choose>
                    <xsl:when test="@regexptype = 'date'">
                        <xsl:call-template name="date-value">
                            <xsl:with-param name="value" select="."/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="@regexptype = 'datetime'">
                        <xsl:call-template name="datetime-value">
                            <xsl:with-param name="value" select="."/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="."/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_NO_VALUE"/>
            </xsl:otherwise>
        </xsl:choose>
                        
        <xsl:if test="position() != last()"><xsl:value-of select="concat($nl, $nl)"/></xsl:if>
    </xsl:template>
    
    <xsl:template match="entry" mode="html">
            <strong>
                <xsl:choose>
                    <xsl:when test="normalize-space(@label) != ''"><xsl:value-of select="@label"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="@name"/></xsl:otherwise>
                </xsl:choose>
                <xsl:text> : </xsl:text>
            </strong>
            <xsl:choose>
                <xsl:when test="@type = 'CHECKBOX'">
                    <xsl:choose>
                        <xsl:when test="text() = 'true'">
                            <i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_TRUE"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_FALSE"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="normalize-space(.) != ''">
                    <xsl:choose>
                        <xsl:when test="@regexptype = 'date'">
                            <xsl:call-template name="date-value">
                                <xsl:with-param name="value" select="."/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="@regexptype = 'datetime'">
                            <xsl:call-template name="datetime-value">
                                <xsl:with-param name="value" select="."/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="replaceBr">
                                <xsl:with-param name="input" select="."/>
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_NO_VALUE"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="position() != last()"><br/></xsl:if>
    </xsl:template>
    
    <xsl:template name="date-value">
        <xsl:param name="value"/>
        
        <i18n:date pattern="long" src-pattern="yyyy-MM-dd" value="{$value}"/>
    </xsl:template>
    
    <xsl:template name="datetime-value">
        <xsl:param name="value"/>
        
        <i18n:date pattern="long" src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX"  value="{$value}"/>
        <xsl:text> </xsl:text>
        <i18n:time pattern="short" src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX"  value="{$value}"/>
    </xsl:template>
    
    <xsl:template name="replaceBr">
        <xsl:param name="input"/>
        <xsl:param name="s1"><xsl:text>
</xsl:text></xsl:param>
        <xsl:choose>
            <xsl:when test="contains($input, $s1)">
                <xsl:variable name="rest">
                    <xsl:call-template name="replaceBr">
                        <xsl:with-param name="input" select="substring-after($input, $s1)"/>
                        <xsl:with-param name="s1" select="$s1"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:value-of select="substring-before($input, $s1)"/>
                <br/>
                <xsl:copy-of select="$rest"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$input"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
