<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
    exclude-result-prefixes="ametys">

    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'checkbox']" mode="field-attribute-class">
        <xsl:attribute name="class">field field-checkboxes</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'checkbox']" mode="input">
        <xsl:param name="name" select="@name"/>
        
        <xsl:variable name="entryValues" select="entry-value/additional-infos/values" />
        <xsl:apply-templates select="additional-infos/options/option">
            <xsl:with-param name="name" select="$name" />
            <xsl:with-param name="entryValues" select="$entryValues" />
        </xsl:apply-templates> 
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'checkbox' and mandatory = 'true']" mode="check-mandatory">
        var field = $j('input[name="<xsl:value-of select="@name"/>"][data-list="<xsl:value-of select="$uniqueId"/>"]:checked');        
        var value = field.val();
        
        var parentField = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>')
        var questionField = $j('#form-<xsl:value-of select="$uniqueId"/>-q-<xsl:value-of select="@name"/>');
        if ((!value || value == '') &amp;&amp; !parentField.is(":hidden") &amp;&amp; !parentField.prop('disabled') &amp;&amp; !questionField.hasClass("preview-hide"))
        {
            AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', "<i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_MANDATORY"/>");
        }
    </xsl:template>
    
    <xsl:template match="option[@format = 'checkbox' and @multiple = 'true']">
        <xsl:param name="name"/>
        <xsl:param name="entryValues"/>
        
        <div class="field field-checkbox" id="{translate($name, ' ', '_')}_{$uniqueId}">
            <xsl:apply-templates select="." mode="label">
                <xsl:with-param name="name" select="$name" />
                <xsl:with-param name="entryValues" select="$entryValues" />
            </xsl:apply-templates> 
            <div class="input input-checkbox">
                <xsl:apply-templates select="." mode="input">
                    <xsl:with-param name="name" select="$name" />
                    <xsl:with-param name="entryValues" select="$entryValues" />
                </xsl:apply-templates>
            </div>
            
        </div>
    </xsl:template>
    
    <xsl:template match="option[@format = 'checkbox' and @multiple = 'false']">
        <xsl:param name="name"/>
        <xsl:param name="entryValues"/>
        
        <div class="field field-radio" id="{translate($name, ' ', '_')}_{$uniqueId}">
            <xsl:apply-templates select="." mode="label">
                <xsl:with-param name="name" select="$name" />
                <xsl:with-param name="entryValues" select="$entryValues" />
            </xsl:apply-templates> 
            <div class="input input-radio">
                <xsl:apply-templates select="." mode="input">
                    <xsl:with-param name="name" select="$name" />
                    <xsl:with-param name="entryValues" select="$entryValues" />
                </xsl:apply-templates>
            </div>
            
        </div>
    </xsl:template>
    
    <xsl:template match="option[@format = 'checkbox' and @other = 'true']" mode="label">
        <xsl:param name="name"/>
        <xsl:param name="entryValues"/>
        
        <div class="label other">
            <label for="{translate($name, ' ', '_')}_{@value}"><i18n:text i18n:key="PLUGINS_FORMS_DISPLAY_OTHER_OPTION"/></label>
            <input type="text" id="ametys-other-{$name}" name="ametys-other-{$name}" onkeyup="AmetysFormsHelper.onFormOtheroptKeyup(this, '{translate($name, ' ', '_')}_{@value}')" >
                <xsl:if test="count($entryValues/value[@isOther = 'true']) > 0">
                    <xsl:attribute name="value"><xsl:value-of select="$entryValues/value[@isOther = 'true']/@val" /></xsl:attribute>
                </xsl:if>
            </input>
        </div>
    </xsl:template>
    
    <xsl:template match="option[@format = 'checkbox'  and not(@other)]" mode="label">
        <xsl:param name="name"/>
        <xsl:param name="entryValues"/>
        
        <div class="label">
            <label for="{translate($name, ' ', '_')}_{@value}"><xsl:value-of select="label"/></label>
        </div>
    </xsl:template>
    
    <xsl:template match="option[@format = 'checkbox' and @multiple = 'false']" mode="input">
        <xsl:param name="name"/>
        <xsl:param name="entryValues"/>
        
        <xsl:variable name="value" select="@value"/>
        <input type="radio" id="{translate($name, ' ', '_')}_{@value}" name="{$name}" value="{@value}" data-list="{$uniqueId}">
            <xsl:if test="@cost">
                <xsl:attribute name="data-cost" ><xsl:value-of select="@cost" /></xsl:attribute>
            </xsl:if>
            <xsl:if test="count($entryValues/value[@val = $value]) > 0 or (@other = 'true' and count($entryValues/value[@isOther = 'true']) > 0)">
                <xsl:attribute name="checked">true</xsl:attribute>
            </xsl:if>
        </input>
    </xsl:template>
    
    <xsl:template match="option[@format = 'checkbox' and @multiple = 'true']" mode="input">
        <xsl:param name="name"/>
        <xsl:param name="entryValues"/>
        
        <xsl:variable name="value" select="@value"/>
        <input type="checkbox" id="{translate($name, ' ', '_')}_{@value}" name="{$name}" value="{@value}" data-list="{$uniqueId}">
            <xsl:if test="@cost">
                <xsl:attribute name="data-cost" ><xsl:value-of select="@cost" /></xsl:attribute>
            </xsl:if>
            <xsl:if test="count($entryValues/value[@val = $value]) > 0 or (@other = 'true' and count($entryValues/value[@isOther = 'true']) > 0)">
                <xsl:attribute name="checked">true</xsl:attribute>
            </xsl:if>
        </input>
    </xsl:template>
    
    <xsl:template match="question[format/@value = 'checkbox']" mode="listener">
           <xsl:variable name="questionName" select="@name"/>
           <xsl:variable name="canRead" select="@canRead"/>
           $j( document ).ready(function() {
               var radioElements = document.getElementsByName("<xsl:value-of select="$questionName"/>");
               for(var i = 0; i &lt; radioElements.length; i++)
               {
                   var onChangeFunction = function() {
                        <xsl:for-each select="rules/rule">
                            var ruleTargetName = "<xsl:value-of select="@target-name"/>";
                            var ruleAction = "<xsl:value-of select="@action"/>";
                            var ruleValue = "<xsl:value-of select="@value"/>";
                            var checkboxId = "<xsl:value-of select="translate($questionName, ' ', '_')"/>_" + ruleValue;
                     
                            AmetysFormsHelper.onFormRuleActionChange("<xsl:value-of select="$uniqueId" />", ruleTargetName, ruleAction, $j('#' + checkboxId)[0].checked, <xsl:value-of select="$canRead" />, <xsl:value-of select="$preview" />);
                        </xsl:for-each>

                        var isChecked = $j("#<xsl:value-of select="$questionName"/>_<xsl:value-of select="$other-val" />").is(":checked");
                        if (!isChecked)
                        {
                            $j("#ametys-other-<xsl:value-of select="$questionName"/>").val("");
                        }
                        
                        FormListenersHelper.executeListenerForInputs("<xsl:value-of select="$uniqueId" />", "<xsl:value-of select="../@number" />");
                    }
                    
                    // Do it at initialization
                    onChangeFunction();
                    
                    // Add change listener
                    radioElements[i].addEventListener("change", function(){
                       onChangeFunction();
                    });
               }
           });
    </xsl:template>
    
</xsl:stylesheet>