<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    exclude-result-prefixes="ametys">

    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'combobox' and mandatory = 'true' and additional-infos/options/option[@other = 'true']]" mode="check-mandatory">
        var field = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>')
        var value = field.val();
        
        var otherField = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$other-val"/>')
        var otherValue = otherField.val();
        var isEmpty = otherValue == '' &amp;&amp; (value == '' || value == '<xsl:value-of select="$other-val" />');

        var parentField = $j('#form-<xsl:value-of select="$uniqueId"/>-q-<xsl:value-of select="@name"/>');
        if (isEmpty &amp;&amp; !field.is(":hidden") &amp;&amp; !field.prop('disabled') &amp;&amp; !parentField.hasClass("preview-hide"))
        {
            AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', "<i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_MANDATORY"/>");
        }
    </xsl:template>

    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'combobox']" mode="field-attribute-class">
        <xsl:attribute name="class">field field-combobox</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'combobox']" mode="input-attribute-class">
        <xsl:attribute name="class">input input-select<xsl:if test="multiple = 'true'"> multiple</xsl:if><xsl:if test="additional-infos/options/@remoteData = 'true'"> searcheable</xsl:if></xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'combobox']" mode="input">
        <xsl:param name="name" select="@name"/>
        
        <xsl:variable name="entryValues" select="entry-value/additional-infos/values" />
        <select name="{$name}" id="{translate($name, ' ', '_')}_{$uniqueId}" data-list="{$uniqueId}" onchange="onChangeFunction_{translate($name, '-', '_')}_{$uniqueId}(this)" >
            <xsl:if test="multiple = 'true'">
                <xsl:attribute name="multiple" >true</xsl:attribute>
            </xsl:if>
            <xsl:if test="mandatory = 'true'">
                <xsl:attribute name="aria-required">true</xsl:attribute>
            </xsl:if>
            <xsl:if test="placeholder and additional-infos/options/@remoteData = 'false'">
                <option value="" disabled="true" selected="true" hidden="true"><xsl:value-of select="placeholder"/></option>
            </xsl:if>
            <xsl:if test="mandatory != 'true' and multiple != 'true'">
                <option id="empty-{translate($name, ' ', '_')}" value=""/>
            </xsl:if>
            
            <xsl:apply-templates select="additional-infos/options[@remoteData = 'false']/option">
                <xsl:with-param name="name" select="$name" />
                <xsl:with-param name="entryValues" select="$entryValues" />
            </xsl:apply-templates> 
        </select>
    </xsl:template>
    
    <xsl:template match="option[@format = 'combobox']">
        <xsl:param name="name"/>
        <xsl:param name="entryValues"/>
        
        <xsl:apply-templates select="." mode="input">
            <xsl:with-param name="name" select="$name" />
            <xsl:with-param name="entryValues" select="$entryValues" />
        </xsl:apply-templates> 
    </xsl:template>
    
    <xsl:template match="option[@format = 'combobox' and @other = 'true']" mode="input">
        <xsl:param name="name"/>
        <xsl:param name="entryValues"/>
        
        <option id="other-{translate($name, ' ', '_')}" value="{$other-val}">
            <xsl:if test="count($entryValues/value[@isOther = 'true']) > 0">
                <xsl:attribute name="selected">true</xsl:attribute>
            </xsl:if>
            <i18n:text i18n:key="PLUGINS_FORMS_DISPLAY_OTHER_OPTION_COMBOBOX"/>
        </option>
    </xsl:template>
    
    <xsl:template match="option[@format = 'combobox' and not(@other)]" mode="input">
        <xsl:param name="name"/>
        <xsl:param name="entryValues"/>

        <xsl:variable name="value" select="@value"/>
        <option value="{@value}">
            <xsl:if test="@cost">
                <xsl:attribute name="data-cost" ><xsl:value-of select="@cost" /></xsl:attribute>
            </xsl:if>
            <xsl:if test="count($entryValues/value[@val = $value]) > 0">
                <xsl:attribute name="selected">true</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="."/>
        </option>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'combobox']" mode="additional-field">
        <xsl:param name="name" select="@name"/>
        
        <xsl:variable name="entryValues" select="entry-value/additional-infos/values" />
        <xsl:if test="additional-infos/options/option[@other = 'true']">
            <xsl:variable name="value" select="additional-infos/options/option[@other = 'true']/@value"/>
            
            <div class="field field-other">
                 <div class="label label-other">
                    <label for="{translate($name, ' ', '_')}_{$value}" id="{translate($name, ' ', '_')}_{$value}_label" ><i18n:text i18n:key="PLUGINS_FORMS_DISPLAY_OTHER_OPTION_COMBOBOX_LABEL"/></label>
                </div>
                <div class="input input-other">
                    <input type="text" name="ametys-other-{$name}" id="{translate($name, ' ', '_')}_{$value}" >
                        <xsl:if test="count($entryValues/value[@isOther = 'true']) > 0">
                            <xsl:attribute name="value"><xsl:value-of select="$entryValues/value[@isOther = 'true']/@val" /></xsl:attribute>
                        </xsl:if>
                    </input>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="question[format/@value = 'combobox']" mode="listener">
        function onChangeFunction_<xsl:value-of select="translate(@name, '-', '_')" />_<xsl:value-of select="$uniqueId" />(select) {
            AmetysFormsHelper.onFormOtheroptSelect(select);
            var canRead = <xsl:value-of select="@canRead"/>;
            <xsl:for-each select="rules/rule">
                var ruleTargetName = "<xsl:value-of select="@target-name"/>";
                var ruleAction = "<xsl:value-of select="@action"/>";
                var ruleValue = "<xsl:value-of select="@value"/>";
                
                var newValue = $j(select).val();
                AmetysFormsHelper.onFormRuleActionChange("<xsl:value-of select="$uniqueId" />", ruleTargetName, ruleAction, newValue &amp;&amp; newValue.includes(ruleValue), canRead, <xsl:value-of select="$preview" />);
            </xsl:for-each>
            
            FormListenersHelper.executeListenerForInputs("<xsl:value-of select="$uniqueId" />", "<xsl:value-of select="../@number" />");
        }

        $j( document ).ready(function() {
            // Do it at initialization
            onChangeFunction_<xsl:value-of select="translate(@name, '-', '_')" />_<xsl:value-of select="$uniqueId" />('#<xsl:value-of select="translate(@name, ' ', '_')"/>_<xsl:value-of select="$uniqueId" />');
        });
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'combobox' and additional-infos/options/@remoteData = 'true']" mode="display-fn">
        var $select = $j('#<xsl:value-of select="translate(@name, ' ', '_')" />_<xsl:value-of select="$uniqueId" />');
        
        var limit = 20;
        var otherLabel = '<xsl:value-of select="ametys:translate('plugin.forms:PLUGINS_FORMS_DISPLAY_OTHER_OPTION_COMBOBOX', ametys:lang())" />';
        $select.select2({
          language: '<xsl:value-of select="ametys:translate('plugin.forms:PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_SELECT2_IMPORT_LANG', ametys:lang())" />',
          placeholder: '<xsl:value-of select="placeholder"/>',
          minimumResultsForSearch: limit, // at least 20 results must be displayed to show filter input
          ajax: {
            url: '<xsl:value-of select="$site-uri-prefix" />/_plugins/forms/get-choice-list-options',
            delay: 250,
            data: function (params) {
                return {
                    search: params.term,
                    sourceType: '<xsl:value-of select="source-type/@value" />',
                    questionId: '<xsl:value-of select="@id" />',
                    page: params.page || 1,
                    limit: limit,
                    lang: '<xsl:value-of select="ametys:lang()" />'
                }
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                var json = typeof data === 'object' ? data : JSON.parse(data);
                <xsl:if test="multiple != 'true' and mandatory != 'true'">
                    if (params.page == 1)
                    {
                     json.unshift({id:"", text:'<i18n:text i18n:key="PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_EMPTY_OPTION_TEXT" i18n:catalogue="plugin.forms"/>'});
                    }
                </xsl:if>
                var hasMore = json.length >= limit;
                <xsl:if test="other-option = 'true'">
                if (!hasMore)
                {
                    json.push({id:"<xsl:value-of select="$other-val" />", text:otherLabel});
                }
                </xsl:if>
                return {
                    results: json,
                    "pagination": {
                        "more": hasMore
                    }
                };
            }
          }
        });
        
        var hasOption = false;
        <xsl:for-each select="entry-value/additional-infos/values/value[not(@isOther)]">
            hasOption = true;
            var option = new Option("<xsl:value-of select="." />", "<xsl:value-of select="@val" />", true, true);
            $select.append(option).trigger('change');
            
            $select.trigger({
                type: 'select2:select',
                params: {
                    data: option
                }
            })
        </xsl:for-each>
        
        if (!hasOption)
        {
            <xsl:for-each select="entry-value/additional-infos/values/value[@isOther]">
                var option = new Option(otherLabel, "<xsl:value-of select="$other-val" />", true, true);
                $select.append(option).trigger('change');
            
                $select.trigger({
                    type: 'select2:select',
                    params: {
                        data: option
                    }
                })
            </xsl:for-each>
        }
        
    </xsl:template>
</xsl:stylesheet>