<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
    exclude-result-prefixes="ametys resolver escape">    
    
    <xsl:variable name="cssPrefix">entry-form-fields</xsl:variable>
    
    <xsl:template match="question">
        <div class="question">
            <xsl:apply-templates select="." mode="question-attribute-class"/>
            
            <div class="field" id="field-{@name}_{$uniqueId}">
                <xsl:apply-templates select="." mode="field-attribute-class"/>
                
                <xsl:apply-templates select="." mode="label"/>
                
                <xsl:apply-templates select="." mode="picture"/>
                
                <xsl:choose>
                    <xsl:when test="@canWrite = 'true'">
                        <div class="input"> 
                            <xsl:apply-templates select="." mode="input-attribute-class"/>
                            <xsl:apply-templates select="." mode="input"/>
                        </div>
                        <xsl:apply-templates select="." mode="additional-field"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="." mode="read-only"/>
                    </xsl:otherwise>
                </xsl:choose>
                
                <div class="field-end"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="question" mode="read-only">
        <div class="{$cssPrefix}__item_value">
            <xsl:choose>
                <xsl:when test="entry-value/value">
                    <xsl:apply-templates select="." mode="read-only-value">
                        <xsl:with-param name="value" select="entry-value/value" />
                    </xsl:apply-templates>    
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_EMPTY_VALUE" i18n:catalogue="plugin.forms"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template> 
    
    <xsl:template match="question" mode="read-only-value">
        <xsl:param name="value" />
        <!-- Do nothing by default  --> 
    </xsl:template>

    <xsl:template match="question" mode="render-mail">
        <!-- Do nothing by default  --> 
    </xsl:template>
    
    <xsl:template match="question" mode="init-restrictions">
        $j( document ).ready(function() {
	        var targetName = "<xsl:value-of select="@name"/>";
	        var canRead = <xsl:value-of select="@canRead"/>;
	        var canWrite = <xsl:value-of select="@canWrite"/>;
	        
	        AmetysFormsHelper.handleRestrictingReading("<xsl:value-of select="$uniqueId" />", targetName, canRead, canWrite, <xsl:value-of select="$preview" />);

           });
    </xsl:template>
    
    <xsl:template match="question" mode="question-attribute-class">
        <xsl:attribute name="class">question</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question" mode="input-attribute-class" priority="-1">
        <xsl:attribute name="class">input</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question" mode="field-attribute-class">
        <xsl:attribute name="class">field</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question" mode="additional-field"/>
    
    <xsl:template match="question" mode="picture">
       <xsl:param name="class">picture</xsl:param>
       <xsl:param name="picture" select="picture"/>
       <xsl:param name="alt" select="picture-alternative" />
       <xsl:param name="idObject" select="@id" />
       <xsl:param name="maxHeight">150</xsl:param>
       <xsl:param name="maxWidth">150</xsl:param>
       
       <xsl:if test="$picture/@type != ''">
            <div class="{$class}">
                <xsl:variable name="uri"><xsl:value-of select="$picture/@uri" />?objectId=<xsl:value-of select="$idObject" /></xsl:variable>
                <img src="{resolver:resolveBoundedImage($picture/@type, $uri, $maxHeight, $maxWidth)}">
                    <xsl:attribute name="alt"><xsl:value-of select="$alt"/></xsl:attribute>
                </img>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="question" mode="label">
        <div class="label">
            <label for="{@name}_{$uniqueId}">
                <span class="q">Q.<xsl:value-of select="count(preceding::question[@canBeAnsweredByUser = 'true']) + 1"/> - </span><xsl:value-of select="title"/>
                <xsl:apply-templates select="." mode="label-description"/>
                <xsl:if test="mandatory = 'true'"><span class="mandatory-marker"><xsl:text> </xsl:text><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/></span></xsl:if>
            </label>
        </div>
    </xsl:template>
    
    <xsl:template match="question" mode="label-description">
        <xsl:if test="description != ''">
            <span class="input-help" title="{escape:unescapeHtml(description)}"><span><i18n:text i18n:key="PLUGINS_FORMS_FORMS_RENDER_INPUT_HELP" i18n:catalogue="plugin.forms"/></span></span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="question[mandatory = 'true']" mode="check-mandatory">
        var field = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>')
        var value = field.val();

        var parentField = $j('#form-<xsl:value-of select="$uniqueId"/>-q-<xsl:value-of select="@name"/>');
        if (value == '' &amp;&amp; !field.is(":hidden") &amp;&amp; !field.prop('disabled')  &amp;&amp; !parentField.hasClass("preview-hide"))
        {
            AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', "<i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_MANDATORY"/>");
        }
    </xsl:template>
    
    <xsl:template match="question" mode="check-values">
        <!--  Do nothing by default -->
    </xsl:template>
    
    <xsl:template match="question" mode="init-values">
        <!--  Do nothing by default -->
    </xsl:template>
    
    <xsl:template match="question" mode="init-rules">
        <!--  Do nothing by default -->
    </xsl:template>
    
    <xsl:template match="question" mode="display-fn">
        <!--  Do nothing by default -->
    </xsl:template>
    
</xsl:stylesheet>    