<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
    exclude-result-prefixes="ametys">

    <xsl:template match="question[@type = 'form.Number']" mode="question-attribute-class">
        <xsl:attribute name="class">question question-number</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Number']" mode="field-attribute-class">
        <xsl:attribute name="class">field field-textarea</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Number']" mode="read-only-value">
        <xsl:param name="value" />
        
        <xsl:value-of select="$value"/>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Number']" mode="render-mail">
        <xsl:value-of select="value"/>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Number']" mode="input">
        <input type="number" name="{@name}" id="{@name}_{$uniqueId}" class="text" onchange="onNumberChangeFunction_{translate(@name, '-', '_')}_{$uniqueId}()">
            <xsl:if test="min">
                <xsl:attribute name="min"><xsl:value-of select="min"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="max">
                <xsl:attribute name="max"><xsl:value-of select="max"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="mandatory = 'true'">
                <xsl:attribute name="aria-required">true</xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="number-type[@value = 'int']">
                    <xsl:attribute name="step">1</xsl:attribute>
                    <xsl:attribute name="placeholder">0</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="step">any</xsl:attribute>
                    <xsl:attribute name="placeholder">0,00</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="entry-value/value">
                <xsl:attribute name="value"><xsl:value-of select="entry-value/value"/></xsl:attribute>
            </xsl:if>
        </input>  
    </xsl:template> 
    
    <xsl:template match="question[@type = 'form.Number']" mode="check-values">
        var value = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>').val();
        <xsl:if test="number-type[@value = 'int']">
            if (value != '' &amp;&amp; !(/^[-+]?\d+$/.test(value)))
            {
                var msg = "<i18n:translate>
                            <i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_INT"/>
                           </i18n:translate>";
                AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', msg);
            }
        </xsl:if>
        
        <xsl:call-template name="test-min-number" >
            <xsl:with-param name="min" select="min-double" />
        </xsl:call-template> 
        <xsl:call-template name="test-min-number" >
            <xsl:with-param name="min" select="min-int" />
        </xsl:call-template> 
        <xsl:call-template name="test-max-number" >
            <xsl:with-param name="max" select="max-double" />
        </xsl:call-template> 
        <xsl:call-template name="test-max-number" >
            <xsl:with-param name="max" select="max-int" />
        </xsl:call-template> 
    </xsl:template>
    
    <xsl:template name="test-min-number">
       <xsl:param name="min"/>
       <xsl:if test="$min">
            var msg = "<i18n:translate>
                            <i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_MIN"/>
                            <i18n:param name="min"><xsl:value-of select="$min"/></i18n:param>
                       </i18n:translate>";
            if (value &amp;&amp; value &lt; parseFloat('<xsl:value-of select="$min"/>'))
            {
                AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', msg);
            }
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="test-max-number">
       <xsl:param name="max"/>
       <xsl:if test="$max">
            var msg = "<i18n:translate>
                            <i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_MAX"/>
                            <i18n:param name="max"><xsl:value-of select="$max"/></i18n:param>
                       </i18n:translate>";
            if (value &amp;&amp; value &gt; parseFloat('<xsl:value-of select="$max"/>'))
            {
                AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', msg);
            }
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Number']" mode="init-rules">
        function onNumberChangeFunction_<xsl:value-of select="translate(@name, '-', '_')" />_<xsl:value-of select="$uniqueId" />() {
            FormListenersHelper.executeListenerForInputs("<xsl:value-of select="$uniqueId" />", "<xsl:value-of select="../@number" />");
        }
    </xsl:template>
</xsl:stylesheet>