/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.actions;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.workflow.SendMailFunction;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workflow.cocoon.AbstractWorkflowAction;
import org.ametys.plugins.workflow.support.WorkflowProvider.AmetysObjectWorkflow;
import org.ametys.web.WebHelper;

import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.WorkflowException;


/**
 * Do action for a form entry
 */
public class DoFormWorkflowAction extends AbstractWorkflowAction
{
    /** The Ametys object resolver */
    protected AmetysObjectResolver _resolver;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _resolver = (AmetysObjectResolver) serviceManager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    protected Map _act(Redirector redirector, Map objectModel, String source, Parameters parameters, int actionId, Map inputs) throws InvalidInputException, WorkflowException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String entryId = request.getParameter("entryId");
        
        FormEntry formEntry = _resolver.resolveById(entryId);
        WebHelper.setPopulationContextAttribute(request, formEntry.getForm().getSite());
        
        AmetysObjectWorkflow workflow = _workflowProvider.getAmetysObjectWorkflow(formEntry);
        
        inputs.put(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY, formEntry);

        String sendMail = request.getParameter("send-mail");
        if (StringUtils.isNotBlank(sendMail))
        {
            inputs.put(SendMailFunction.SEND_MAIL, String.valueOf(sendMail.equals("on")));
            inputs.put(SendMailFunction.SENDER, request.getParameter("sender"));
            inputs.put(SendMailFunction.RECIPIENT, request.getParameter("recipient"));
            inputs.put(SendMailFunction.SUBJECT, request.getParameter("subject"));
            inputs.put(SendMailFunction.BODY, request.getParameter("body"));
        }
        else
        {
            inputs.put(SendMailFunction.SEND_MAIL, "false");
        }
        
        String comment = request.getParameter("comment");
        if (StringUtils.isNotBlank(comment))
        {
            inputs.put("comment", comment);
        }
        workflow.doAction(formEntry.getWorkflowId(), Integer.parseInt(request.getParameter("actionId")), inputs);

        return EMPTY_MAP;
    }

    
    @Override
    protected String _getExceptionContext(Map objectModel, String source, Parameters parameters)
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        String entryId = request.getParameter("entryId");
        
        FormEntry formEntry = _resolver.resolveById(entryId);
        return String.format("for the workflow of instance id: '%d'", formEntry.getWorkflowId());
    }
    
}
