/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.actions;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.cocoon.JSonReader;
import org.ametys.plugins.forms.helper.FormStatisticsHelper;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;

/**
 * Submit a mini-survey
 */
public class ProcessMiniSurveyAction extends ProcessFormAction
{
    /** The form stats helper */
    protected FormStatisticsHelper _formStatsHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _formStatsHelper = (FormStatisticsHelper) serviceManager.lookup(FormStatisticsHelper.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Map<String, Object> result = new HashMap<>();
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        Map<String, String> formResults = _processForm(request);
        if (formResults == null)
        {
            result.put("success", false);
        }
        else
        {
            // Entries are created on default workspace then copy on live. But the copy is async and on live getting results immediatly after creating the entry could return wrong results.
            String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace(request);
            try
            {
                // Force the workspace.
                RequestAttributeWorkspaceSelector.setForcedWorkspace(request, RepositoryConstants.DEFAULT_WORKSPACE);
                
                String formId = request.getParameter("formId");
                
                result.put("success", true);
                result.put("results", _formStatsHelper.getMiniSurveyStatistics(formId));
            }
            finally 
            {
                // Restore context
                RequestAttributeWorkspaceSelector.setForcedWorkspace(request, currentWsp);
            }
        }
        
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
    
}
