/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.workflow;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

/**
 * Set the last modified date for the form ribbon generated on the fly
 */
public class FormRibbonSetLastModifiedAction extends AbstractAction
{
    @SuppressWarnings("unchecked")
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        // Use Server startup time as "last modified", since ribbon.xml is generated from form workflows, read once at startup
        Long serverStartupTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        Optional.ofNullable(objectModel.get(ObjectModelHelper.PARENT_CONTEXT))
                .filter(Map.class::isInstance)
                .map(Map.class::cast)
                .ifPresent(params -> params.put("lastModified", serverStartupTime));
        return Collections.emptyMap();
    }
}
