/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.workflow;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;

import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.generators.FormMailEntryInformationGenerator;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;

/**
 * Generate the entry of a form for a workflow mail
 */
public class MailWorkflowFormEntryInformationGenerator extends FormMailEntryInformationGenerator
{
    /** The form DAO */
    protected FormDAO _formDAO;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _formDAO = (FormDAO) manager.lookup(FormDAO.ROLE);
    }
    
    @Override
    protected void _addAdditionalEntryAttributes(FormEntry entry, AttributesImpl attrs)
    {
        super._addAdditionalEntryAttributes(entry, attrs);
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        Form form = entry.getForm();
        attrs.addCDATAAttribute("dashboardUri", _formDAO.getDashboardUri(form.getSiteName()));
        attrs.addCDATAAttribute("adminDashboardUri", _formDAO.getAdminDashboardUri(form.getSiteName()));
        
        Object comment = request.get("comment");
        if (comment != null)
        {
            attrs.addCDATAAttribute("comment", (String) comment);
        }
        
        UserIdentity userId = entry.getUser();
        User user = userId != null ? _userManager.getUser(userId) : null;
        if (user != null)
        {
            attrs.addCDATAAttribute("user", user.getFullName());
        }
    }
}
