/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.actions;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.right.RightManager;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.dao.FormQuestionDAO;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.sources.ChoiceSourceType;
import org.ametys.plugins.forms.question.types.impl.ChoicesListQuestionType;
import org.ametys.plugins.forms.question.types.impl.ComputedQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItem;
import org.ametys.web.FOAmetysObjectCreationHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Request;

public abstract class AbstractProcessFormAction
extends ServiceableAction {
    protected AmetysObjectResolver _resolver;
    protected FOAmetysObjectCreationHelper _foAmetysObjectCreationHelper;
    protected FormDAO _formDAO;
    protected FormEntryDAO _entryDAO;
    protected FormQuestionDAO _formQuestionDAO;
    protected RightManager _rightManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._foAmetysObjectCreationHelper = (FOAmetysObjectCreationHelper)smanager.lookup(FOAmetysObjectCreationHelper.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._formDAO = (FormDAO)((Object)smanager.lookup(FormDAO.ROLE));
        this._entryDAO = (FormEntryDAO)((Object)smanager.lookup(FormEntryDAO.ROLE));
        this._formQuestionDAO = (FormQuestionDAO)((Object)smanager.lookup(FormQuestionDAO.ROLE));
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    protected void _adaptFormValuesForChoiceList(Form form, Map<String, Object> formInputValues) {
        List<FormQuestion> choiceListQuestions = form.getQuestions().stream().filter(q -> q.getType() instanceof ChoicesListQuestionType).toList();
        for (FormQuestion question : choiceListQuestions) {
            ChoicesListQuestionType type = (ChoicesListQuestionType)question.getType();
            ChoiceSourceType sourceType = type.getSourceType(question);
            String nameForForm = question.getNameForForm();
            if (!formInputValues.containsKey(nameForForm)) continue;
            Object object = formInputValues.get(nameForForm);
            Object newValue = sourceType.removeEmptyOrOtherValue(object);
            if (newValue == null) {
                formInputValues.remove(nameForForm);
                continue;
            }
            formInputValues.put(nameForForm, newValue);
        }
    }

    protected View _getRuleFilteredEntryView(Request request, Form form, View entryView, FormQuestionDAO.FormEntryValues entryValues, Optional<Long> currentStepId) {
        View filteredEntryView = new View();
        for (FormQuestion target : this._getRuleFilteredQuestions(request, form, entryValues, currentStepId)) {
            ViewItem viewItem = entryView.getViewItem(target.getNameForForm());
            filteredEntryView.addViewItem(viewItem);
            this._manageOtherOption(entryView, filteredEntryView, target);
        }
        return filteredEntryView;
    }

    protected abstract List<FormQuestion> _getRuleFilteredQuestions(Request var1, Form var2, FormQuestionDAO.FormEntryValues var3, Optional<Long> var4);

    private void _manageOtherOption(View entryView, View filteredEntryView, FormQuestion target) {
        ChoicesListQuestionType type;
        FormQuestionType formQuestionType = target.getType();
        if (formQuestionType instanceof ChoicesListQuestionType && (type = (ChoicesListQuestionType)formQuestionType).hasOtherOption(target)) {
            ViewItem viewOtherItem = entryView.getViewItem("ametys-other-" + target.getNameForForm());
            filteredEntryView.addViewItem(viewOtherItem);
        }
    }

    protected void _handleComputedValues(List<FormQuestion> questions, FormEntry entry, boolean forEdition) {
        for (FormQuestion question : questions) {
            Object computedValue;
            FormQuestionType questionType = question.getType();
            if (!(questionType instanceof ComputedQuestionType)) continue;
            ComputedQuestionType type = (ComputedQuestionType)questionType;
            if (forEdition && !type.getComputingType(question).canEdit() || (computedValue = type.getComputingType(question).getComputedValue(question, entry)) == null) continue;
            entry.setValue(question.getNameForForm(), computedValue);
        }
    }
}

