/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.content.data;

import java.sql.Types;

import org.ametys.plugins.forms.content.Field;

/**
 * Class representing a field value.
 */
public class FieldValue
{
    
    /** The database column name. */
    protected String _columnName;
    
    /** The database column type (from {@link java.sql.Types}). */
    protected int _type;
    
    /** The value. */
    protected Object _value;
    
    /** The corresponding field. */
    protected Field _field;
    
    /**
     * Default constructor.
     */
    public FieldValue()
    {
        this("", Types.OTHER, null, null);
    }
    
    /**
     * Constructor with parameters.
     * @param columnName the column name.
     * @param type the column type.
     * @param value the entry value.
     * @param field the corresponding field.
     */
    public FieldValue(String columnName, int type, Object value, Field field)
    {
        this._columnName = columnName;
        this._type = type;
        this._value = value;
        this._field = field;
    }
    
    /**
     * Copy constructor.
     * @param value the value.
     */
    public FieldValue(FieldValue value)
    {
        this(value.getColumnName(), value.getType(), value.getValue(), value.getField());
    }
    
    /**
     * Get the columnName.
     * @return the columnName
     */
    public String getColumnName()
    {
        return _columnName;
    }
    
    /**
     * Set the columnName.
     * @param columnName the columnName to set
     */
    public void setColumnName(String columnName)
    {
        this._columnName = columnName;
    }
    
    /**
     * Get the type.
     * @return the type
     */
    public int getType()
    {
        return _type;
    }
    
    /**
     * Set the type.
     * @param type the type to set
     */
    public void setType(int type)
    {
        this._type = type;
    }
    
    /**
     * Get the value.
     * @return the value
     */
    public Object getValue()
    {
        return _value;
    }
    
    /**
     * Set the value.
     * @param value the value to set
     */
    public void setValue(Object value)
    {
        this._value = value;
    }
    
    /**
     * Get the corresponding field.
     * @return the corresponding field.
     */
    public Field getField()
    {
        return _field;
    }
    
    /**
     * Set the corresponding field.
     * @param field the corresponding field to set.
     */
    public void setField(Field field)
    {
        this._field = field;
    }
    
}
