/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.sources;

import java.util.HashMap;
import java.util.Map;

/**
 * Class for creating choice options
 */
public class ChoiceOption
{
    private Object _value;
    
    /**
     * Create a {@link ChoiceOption}
     * @param value the value of the option
     */
    public ChoiceOption(Object value) 
    {
        _value = value;
    }
    
    /**
     * Get the option value
     * @return the value
     */
    public Object getValue()
    {
        return _value;
    }
    
    /**
     * Set the new value
     * @param value the new value
     */
    public void setValue(Object value)
    {
        _value = value;
    }

    /**
     * Get all attributes for this option
     * @return the attributes 
     */
    public Map<String, Object> getAttributes() 
    {
        Map<String, Object> attrs = new HashMap<>();
        attrs.put("value", _value);
        return attrs;
    }
    
    @Override
    public String toString()
    {
        return _value.toString();
    }
    
    @Override
    public boolean equals(Object obj)
    {
        if (obj == null)
        {
            return false;
        }

        if (!(obj instanceof ChoiceOption))
        {
            return false;
        }

        if (this == obj)
        {
            return true;
        }
        
        return ((ChoiceOption) obj).getValue().equals(_value);
    }
    
    @Override
    public int hashCode()
    {
        return _value.hashCode();
    }
}
