/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.generators;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.plugins.forms.generators.FormEntryInformationGenerator;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormMailQuestionGenerator
extends FormEntryInformationGenerator {
    @Override
    protected void _checkRights(FormEntry entry) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Boolean ignoreRight = (Boolean)request.getAttribute("ignore-right");
        if (ignoreRight == null || !ignoreRight.booleanValue()) {
            super._checkRights(entry);
        }
    }

    @Override
    protected List<FormQuestion> _getQuestions(FormEntry entry, Optional<Long> currentStepId) {
        Map params = (Map)this.objectModel.get("parent-context");
        String questionName = (String)params.get("questionName");
        return List.of(entry.getForm().getQuestion(questionName));
    }

    @Override
    protected void _saxQuestion(FormQuestion question, FormEntry entry) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("type", question.getType().getId());
        attrs.addCDATAAttribute("format", question.getType().getStorageType(question));
        attrs.addCDATAAttribute("label", question.getTitle());
        attrs.addCDATAAttribute("name", question.getNameForForm());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"question", (Attributes)attrs);
        question.getType().saxEntryValue(this.contentHandler, question, entry);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"question-infos");
        question.getType().saxAdditionalInfos(this.contentHandler, question);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"question-infos");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"question");
    }
}

