/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a question button.<br>
 * This button is disabled as soon as form has entries, except for richtext field
 * @private
 */
Ext.define('Ametys.plugins.forms.controllers.FormQuestionController', {
    extend: 'Ametys.plugins.forms.controllers.FormController',
    
    _updateTooltipDescription: function(description, params)
    {
		description = this.callParent(arguments);
		
        if (params.hasEntries && params.questionType != 'form.RichText')
        {
			this._hasError = true;
			description += this._addTooltipDescription(description, 'has-entries');
        }
        return description;
    }
});
