--
--  Copyright 2021 Anyware Services
--
--  Licensed under the Apache License, Version 2.0 (the "License");
--  you may not use this file except in compliance with the License.
--  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing, software
--  distributed under the License is distributed on an "AS IS" BASIS,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the License for the specific language governing permissions and
--  limitations under the License.
--

BEGIN;

DROP TABLE IF EXISTS Form_Session;
CREATE TABLE Form_Session (
    sessionId INTEGER,
    formId VARCHAR(64),
    login VARCHAR(64),
    population VARCHAR(200),
    IPAddress VARCHAR(32),
    submittedAt TIMESTAMP,
    PRIMARY KEY(sessionId)
);

DROP TABLE IF EXISTS Form_Answer;
CREATE TABLE Form_Answer (
    sessionId INTEGER,
    questionId VARCHAR(64),
    answer TEXT,
    PRIMARY KEY(sessionId, questionId)
);

DROP SEQUENCE IF EXISTS seq_form_session;

CREATE SEQUENCE seq_form_session;

COMMIT;
