<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:math="java.lang.Math" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              extension-element-prefixes="math ametys resolver">

    <xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>
    <xsl:import href="view://stylesheets/utils.xsl"/>
    <xsl:import href="view://stylesheets/forms/questions/common/common-questions.xsl"/>
    <xsl:import href="formQuestion://formQuestion2html.xsl"/>
    
    <xsl:param name="preview">false</xsl:param>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    <xsl:variable name="renderingContext" select="ametys:renderingContext()"/>
    
    <xsl:template name="head-css">
        <xsl:if test="$preview = 'true'">
            <link rel="stylesheet" href="{ametys:pluginResourceURL('forms', 'css/preview.css')}"/>
        </xsl:if>
        <link rel="stylesheet" href="{ametys:pluginResourceURL('forms', 'vendor/css/select2/select2.css')}"/>
    </xsl:template>
    
    <xsl:template name="head-scripts">
        <script type="text/javascript">
            $j( document ).ready(function() {
                AmetysFormsHelper.initForm('<xsl:value-of select="$uniqueId"/>');
            });
            
            function showSuccess_<xsl:value-of select="$uniqueId"/>(isInQueue, rankInQueue)
            {
                var id = "<xsl:value-of select="$uniqueId" />";
                <xsl:for-each select="form/page">
                    AmetysFormsHelper.stopRefreshing(id, "<xsl:value-of select="position()" />");
                </xsl:for-each>
                var mode = "<xsl:value-of select="$redirectMode" />";
                if (mode == "same-page")
                {
                    $j("#form-<xsl:value-of select="$uniqueId"/>-display").hide();
                    $j("#form-<xsl:value-of select="$uniqueId"/>-success").show();
                    if (isInQueue)
                    {
                        var html = "<i18n:translate>
                                        <i18n:text i18n:key="PLUGINS_FORMS_RENDER_QUEUE_SUCCESS" i18n:catalogue="plugin.forms"/>
                                        <i18n:param name="rank">" + rankInQueue + "</i18n:param>
                                    </i18n:translate>";
                        $j("#form-<xsl:value-of select="$uniqueId"/>-success-queue").html(html);
                        $j("#form-<xsl:value-of select="$uniqueId"/>-success-queue").show();            
                    }
                }
                else
                {
                    var redirectPageId = "";
                    <xsl:if test="$redirectPageId != ''">
                        redirectPageId = "<xsl:value-of select="resolver:resolve('page', $redirectPageId, false())" />";
                    </xsl:if>
                
                    var submitOnOtherPage = <xsl:value-of select="$otherPage" />;
                    var successUrl = mode == "selected-page" 
                        ? redirectPageId
                        : '<xsl:value-of select="$site-uri-prefix"/>/<xsl:value-of select="$lang"/>/_plugins/forms/page/form/success.html';
                    if (isInQueue)
                    {
                        successUrl += '?isInQueue=' + isInQueue + '&amp;rankInQueue=' + rankInQueue;
                    }
                    
                    if (submitOnOtherPage)
                    {
                        window.open(successUrl);
                    }
                    else
                    {
                        window.location = successUrl;
                    }
                }
            }
            
            function showErrors_<xsl:value-of select="$uniqueId"/>(errors)
            {
                var id = "<xsl:value-of select="$uniqueId" />";
                
                for (var i in errors)
                {
                    if (errors[i].name)
                    {
                        AmetysFormsHelper.addFormError(id, errors[i].name + "_" + id, errors[i].label, errors[i].message);
                    }
                    else
                    {
                        AmetysFormsHelper.addGlobalFormError(id, errors[i].message);
                    }
                }
                
                AmetysFormsHelper._showFormErrors(id, 1);
                
                <xsl:for-each select="form/page">
                    AmetysFormsHelper.stopRefreshing(id, "<xsl:value-of select="position()" />");
                </xsl:for-each>
                
                <xsl:if test="$preview != 'true' and ametys:isCaptchaRequired(ametys:zoneItemId())">
                    refresh_form_captcha_<xsl:value-of select="$uniqueId"/>();
                </xsl:if>
            }
            
            <xsl:for-each select="form/page">
                function checkForm_<xsl:value-of select="$uniqueId"/>_<xsl:value-of select="position()"/>()
                {
                    AmetysFormsHelper.resetFormErrors('<xsl:value-of select="$uniqueId"/>');
                    
                    // Check mandatory fields
                    <xsl:apply-templates select="question[mandatory = 'true']" mode="check-mandatory"/>

                    // Check RegExp
                    <xsl:apply-templates select="question[regexp and regexp/@value != ' ']" mode="check-regexp"/>
                    
                    // Check values
                    <xsl:apply-templates select="question" mode="check-values"/>
                }
                
                // Init the question values
                <xsl:apply-templates select="question" mode="init-values"/>
                
                //Set the rules
                <xsl:apply-templates select="question" mode="init-rules"/>
                
                //Set the restrictions
                <xsl:apply-templates select="question" mode="init-restrictions"/>
                
                function branches_<xsl:value-of select="$uniqueId"/>_<xsl:value-of select="position()"/>()
                {
                    if (1 == 0)
                    {
                        // Nothing
                    }
                    <xsl:for-each select="branches/rule">
                    else if ($j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>').val() == '<xsl:value-of select="@value"/>'
                          || $j('#<xsl:value-of select="concat(@name, '_', @value)"/>').get(0) &amp;&amp; $j('#<xsl:value-of select="concat(@name, '_', @value)"/>').get(0).checked)
                    {
                        <xsl:if test="@type = 'FINISH'">
                            // Finish form
                            return 0;
                        </xsl:if>
                        <xsl:if test="@type = 'JUMP'">
                           <xsl:variable name="pageId" select="@page"/>
                            // Returns position of next page
                            return (<xsl:value-of select="count(//page[@id = $pageId]/preceding::page)"/> + 1);
                        </xsl:if>
                    }
                    </xsl:for-each>
                    <xsl:if test="branches/page-rule">
                    else
                    {
                        <xsl:if test="branches/page-rule/@type = 'FINISH'">
                            // Finish form
                            return 0;
                        </xsl:if>
                        <xsl:if test="branches/page-rule/@type = 'JUMP'">
                           <xsl:variable name="pageId" select="branches/page-rule/@page"/>
                            // Returns position of next page
                            return (<xsl:value-of select="count(//page[@id = $pageId]/preceding::page)"/> + 1);
                        </xsl:if>
                    }</xsl:if>
                    
                    // No rule ... 
                    if ("<xsl:value-of select="position()"/>" == "<xsl:value-of select="last()"/>")
                    {
                        // ... it's the last page
                        return 0;
                    }
                    // ... go to next page
                    return -1;
                }
            </xsl:for-each>
            
            <xsl:call-template name="form-preview-go-to-page" />
        </script>
        
        <script src="{$uri-prefix}/plugins/forms/resources/js/FormListenersHelper.{$lang}.js" type="text/javascript"/>
        <script src="{$uri-prefix}/plugins/forms/resources/js/AmetysFormsHelper.{$lang}.js" type="text/javascript"/>
        
        <script src="{ametys:pluginResourceURL('forms', 'vendor/js/select2/select2.js')}" type="text/javascript"/>
        <xsl:variable name="langUrl">vendor/js/select2/i18n/<xsl:value-of select="ametys:translate('plugin.forms:PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_SELECT2_IMPORT_LANG', ametys:lang())" />.js</xsl:variable>
        <script src="{ametys:pluginResourceURL('forms', $langUrl)}" type="text/javascript"/>
    </xsl:template>
    
    <xsl:template name="view">
        <xsl:param name="level">2</xsl:param>
        <div id="form-{$uniqueId}">
            <xsl:if test="$preview = 'true'">
                <xsl:attribute name="class">preview</xsl:attribute>
            </xsl:if>
            
            <xsl:call-template name="form-no-access" />
            <xsl:if test="form/@hasReadAccess = 'true'">
                
                <xsl:call-template name="form-configured-warning" />
                <xsl:if test="$preview = 'true' or form/@isConfigured = 'true'">

                    <xsl:call-template name="form-success-on-same-page" />

                    <div id="form-{$uniqueId}-display">
                        <xsl:call-template name="form-opening-dates" />
                        <xsl:if test="$preview = 'true' or form/@scheduleStatus = 'OPEN'">

                            <xsl:call-template name="form-hint"/>
                    
                            <xsl:call-template name="form-limit-text" />
                            <xsl:if test="$preview = 'true' or form/@isClosed != 'true'">
                                <form class="form" id="form-{$uniqueId}-form" method="post" action="{$site-uri-prefix}/_plugins/forms/{$lang}/finish/{$uniqueId}" data-ametys-form="true">
                                    <xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
                                    <xsl:call-template name="form-additional-attributes" />
                                 
                                    <div>
                                        <input type="hidden" name="formId" value="{form/@id}"/>
                                    
                                        <xsl:apply-templates select="form/page">
                                            <xsl:with-param name="level" select="$level"/>
                                        </xsl:apply-templates>
                                    
                                        <div style="display:none">
                                            <xsl:call-template name="form-captcha" />
                                        </div>
                                    </div>
                                </form>
                            </xsl:if>
                        
                            <xsl:call-template name="form-additional-info" />
                    </xsl:if>
                    </div>
                </xsl:if>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="form-additional-info">
        <!-- Nothing -->
    </xsl:template>
    
    <xsl:template name="form-additional-attributes">
        <!-- Nothing -->
    </xsl:template>
    
    <xsl:template name="form-success-on-same-page">
        <xsl:if test="$redirectMode = 'same-page'">
            <div class="form-success" id="form-{$uniqueId}-success">
                <p class="message"><i18n:text i18n:key="PLUGINS_FORMS_RENDER_SUCCESS"/></p>
                <p class="message in-queue" id="form-{$uniqueId}-success-queue"></p>
            </div>
            <script type="text/javascript">
                $j("#form-<xsl:value-of select="$uniqueId"/>-success-queue").hide();
                $j("#form-<xsl:value-of select="$uniqueId"/>-success").hide();
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="form-hint">
        <p class="mandatory-hint" id="form-{$uniqueId}-mandatory-hint">
            <i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_LABEL" i18n:catalogue="plugin.web"/>
        </p>
        <script type="text/javascript">
            <xsl:if test="count(form/page/question[mandatory = 'true']) = 0">
                $j("#form-<xsl:value-of select="$uniqueId"/>-mandatory-hint").hide();
            </xsl:if>
        </script>
    </xsl:template>
    
    <xsl:template match="page">
        <xsl:param name="level"/>
        
        <xsl:variable name="isFirstPage" select="position() = 1"/>
        <xsl:variable name="isLastPage" select="position() = last()"/>
        <xsl:variable name="pageId" select="@id"/>
        <xsl:variable name="pagePosition" select="position()"/>
        
        <div id="form-{$uniqueId}-page-{$pagePosition}">
            <a name="form-{$uniqueId}-{@name}"/>
            
            <div id="form-{$uniqueId}-page-{$pagePosition}-questions">
            <xsl:for-each select="question">
                <div id="form-{$uniqueId}-q-{@name}" class="form-question" data-id="{@id}" data-name="{@name}" data-page-id="{$pageId}" data-page-position="{$pagePosition}">
                   <xsl:apply-templates select="."/>
                </div>
            </xsl:for-each>
            </div>
            
            <div id="captcha-div-{$pagePosition}-{$uniqueId}">
            </div>
            
            <div class="buttons" id="buttons-{$pagePosition}-{$uniqueId}" style="display:none">
                <xsl:choose>
                    <xsl:when test="$isLastPage">
                            <xsl:if test="not($isFirstPage)">
                                <xsl:call-template name="common-utils-input-submit">
                                    <xsl:with-param name="id">form-previous-<xsl:value-of select="position()"/>-<xsl:value-of select="$uniqueId"/></xsl:with-param>
                                    <xsl:with-param name="class-name">previous</xsl:with-param>
                                    <xsl:with-param name="i18nkey">PLUGINS_FORMS_PAGE_FORM_PRECEDE_BUTTON</xsl:with-param>
                                    <xsl:with-param name="onclick">try { AmetysFormsHelper.goToPreviousPage('<xsl:value-of select="$uniqueId"/>', <xsl:value-of select="position()"/>); } catch(e) {} return false;</xsl:with-param>
                                </xsl:call-template>
                            </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                            <xsl:if test="not($isFirstPage)">
                                <xsl:call-template name="common-utils-input-submit">
                                    <xsl:with-param name="id">form-previous-<xsl:value-of select="position()"/>-<xsl:value-of select="$uniqueId"/></xsl:with-param>
                                    <xsl:with-param name="class-name">previous</xsl:with-param>
                                    <xsl:with-param name="i18nkey">PLUGINS_FORMS_PAGE_FORM_PRECEDE_BUTTON</xsl:with-param>
                                    <xsl:with-param name="onclick">try { AmetysFormsHelper.goToPreviousPage('<xsl:value-of select="$uniqueId"/>', <xsl:value-of select="position()"/>); } catch(e) {} return false;</xsl:with-param>
                                </xsl:call-template>
                            </xsl:if>
                            <xsl:call-template name="common-utils-input-submit">
                                <xsl:with-param name="id">form-next-<xsl:value-of select="position()"/>-<xsl:value-of select="$uniqueId"/></xsl:with-param>
                                <xsl:with-param name="class-name">next</xsl:with-param>
                                <xsl:with-param name="i18nkey">PLUGINS_FORMS_PAGE_FORM_NEXT_BUTTON</xsl:with-param>
                                <xsl:with-param name="onclick">try { AmetysFormsHelper.goToNextPage('<xsl:value-of select="$uniqueId"/>', <xsl:value-of select="position()"/>, <xsl:value-of select="count(../page)"/>); } catch(e) {} return false;</xsl:with-param>
                            </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
    
                <xsl:call-template name="submit-button">
                    <xsl:with-param name="pos" select="$pagePosition" />
                    <xsl:with-param name="formId" select="../@id" />
                </xsl:call-template>
            </div>
        </div>
        
        <xsl:call-template name="page-js">
            <xsl:with-param name="isFirstPage" select="$isFirstPage"/>
            <xsl:with-param name="isLastPage" select="$isLastPage"/>
            <xsl:with-param name="pageId" select="$pageId"/>
            <xsl:with-param name="pagePosition" select="$pagePosition"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="form-captcha">
        <input type="hidden" name="ametys-zone-item-id" value="{ametys:zoneItemId()}" />

        <xsl:if test="$preview != 'true' and ametys:isCaptchaRequired(ametys:zoneItemId())">
        <div class="captcha" id="captcha-{$uniqueId}">
            <div class="field">
                <div class="input">
                <xsl:call-template name="captcha">
                    <xsl:with-param name="key-name" select="'ametys-captcha-key'"/>
    
                    <xsl:with-param name="value-name" select="'ametys-captcha'"/>
                    <xsl:with-param name="value-id" select="concat('ametys-captcha_', $uniqueId)"/>
                    <xsl:with-param name="value-class">captcha</xsl:with-param>
    
                    <xsl:with-param name="image-alt"/>
                    <xsl:with-param name="image-alt-i18n" select="false()"/>
                    <xsl:with-param name="image-class">captcha-image</xsl:with-param>
                
                    <xsl:with-param name="image-height">50</xsl:with-param>
                    <xsl:with-param name="image-width">160</xsl:with-param>
                
                    <xsl:with-param name="placeholder" select="'PLUGINS_FORMS_FIELD_CAPTCHA_PLACEHOLDER'"/>
                    <xsl:with-param name="placeholder-i18n" select="true()"/>
                    <xsl:with-param name="placeholder-catalogue" select="'plugin.forms'"/>
                    <xsl:with-param name="js-funcname-torefresh">refresh_form_captcha_<xsl:value-of select="$uniqueId"/></xsl:with-param>
                </xsl:call-template>
                </div>
                <div class="field-end"/>
            </div>
        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="page-js">
        <xsl:param name="isFirstPage" />
        <xsl:param name="isLastPage"/>
        <xsl:param name="pageId"/>
        <xsl:param name="pagePosition"/>
        
        <script type="text/javascript">
            <xsl:apply-templates select="question" mode="display-fn" />
            <xsl:if test="not($isFirstPage)">
                $j("#form-<xsl:value-of select="$uniqueId"/>-page-<xsl:value-of select="$pagePosition"/>").hide();
	        </xsl:if>
        </script>
    </xsl:template>
    
    <xsl:template name="submit-button">
        <xsl:param name="pos" />
        <xsl:param name="formId" />
    
        <xsl:choose>
            <xsl:when test="$preview = 'true'">
                <xsl:call-template name="submit-button-preview" >
                    <xsl:with-param name="pos" select="$pos" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="submit-button-front">
                    <xsl:with-param name="pos" select="$pos" />
                    <xsl:with-param name="formId" select="$formId" />
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="submit-button-preview">
        <xsl:param name="pos" />
        
        <xsl:call-template name="common-utils-input-submit">
            <xsl:with-param name="id">submit-<xsl:value-of select="$pos"/>-<xsl:value-of select="$uniqueId"/></xsl:with-param>
            <xsl:with-param name="class-name">submit</xsl:with-param>
            <xsl:with-param name="i18nkey">PLUGINS_FORMS_PAGE_FORM_FINISH_BUTTON</xsl:with-param>
            <xsl:with-param name="disabled" select="true()"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="submit-button-front">
        <xsl:param name="pos" />
        <xsl:param name="formId" />
        
        <xsl:call-template name="common-utils-input-submit">
            <xsl:with-param name="id">submit-<xsl:value-of select="$pos"/>-<xsl:value-of select="$uniqueId"/></xsl:with-param>
            <xsl:with-param name="class-name">submit</xsl:with-param>
            <xsl:with-param name="i18nkey">PLUGINS_FORMS_PAGE_FORM_FINISH_BUTTON</xsl:with-param>
            <xsl:with-param name="onclick">try { AmetysFormsHelper.endForm('<xsl:value-of select="$uniqueId" />', <xsl:value-of select="$pos"/>); } catch(e) {} return false;</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="form-limit-text">
        <xsl:if test="$preview != 'true'">
            <xsl:choose>
                <xsl:when test="form/@user-already-answer = 'true'">
                    <div class="form-user-already-answer">
                         <p><i18n:text i18n:key="PLUGINS_FORMS_LIMIT_ENTRIES_ALREADY_ANSWERED"/></p>
                    </div>
                </xsl:when>
                <xsl:when test="form/@limit-text">
                    <div class="form-limit-reached">
                        <p>
                            <xsl:call-template name="text.nl2br">
                                <xsl:with-param name="input"><xsl:value-of select="form/@limit-text"/></xsl:with-param>
                            </xsl:call-template>
                        </p>
                    </div>
                </xsl:when>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="form-opening-dates">
        <xsl:if test="form/@scheduleStatus != 'OPEN'">
            <div class="form-opening-dates">
                <p>
                    <xsl:choose>
                        <xsl:when test="form/@scheduleStatus = 'OVER'">
                            <i18n:translate>
                                <i18n:text i18n:key="PLUGINS_FORMS_OPENING_SCHEDULE_OVER_END_DATE"/>
                                <i18n:param><i18n:date pattern="long" src-pattern="yyyy-MM-dd"><xsl:value-of select="form/@endDate"/></i18n:date></i18n:param>
                            </i18n:translate>
                        </xsl:when>
                        <xsl:when test="form/@scheduleStatus = 'COMING'">
                            <xsl:choose>
                                <xsl:when test="form/@startDate and form/@endDate">
                                    <i18n:translate>
                                        <i18n:text i18n:key="PLUGINS_FORMS_OPENING_SCHEDULE_COMING_START_END_DATE"/>
                                        <i18n:param><i18n:date pattern="long" src-pattern="yyyy-MM-dd"><xsl:value-of select="form/@startDate"/></i18n:date></i18n:param>
                                        <i18n:param><i18n:date pattern="long" src-pattern="yyyy-MM-dd"><xsl:value-of select="form/@endDate"/></i18n:date></i18n:param>
                                    </i18n:translate>
                                </xsl:when>
                                <xsl:when test="form/@startDate">
                                    <i18n:translate>
                                        <i18n:text i18n:key="PLUGINS_FORMS_OPENING_SCHEDULE_COMING_START_DATE"/>
                                        <i18n:param><i18n:date pattern="long" src-pattern="yyyy-MM-dd"><xsl:value-of select="form/@startDate"/></i18n:date></i18n:param>
                                    </i18n:translate>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test="form/@endDate">
                            <i18n:translate>
                                <i18n:text i18n:key="PLUGINS_FORMS_OPENING_SCHEDULE_OPEN_END_DATE"/>
                                <i18n:param><i18n:date pattern="long" src-pattern="yyyy-MM-dd"><xsl:value-of select="form/@endDate"/></i18n:date></i18n:param>
                            </i18n:translate>
                        </xsl:when>
                    </xsl:choose>
                </p>            
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="form-configured-warning">
        <!-- Back-office warnings -->
        <xsl:if test="$rendering-context = 'back' and form/@isConfigured != 'true'">
            <xsl:variable name="htmlMessage">
                <i18n:text i18n:key="PLUGINS_FORMS_NOT_CONFIGURED_ERROR"/>
            </xsl:variable>
                        
            <xsl:call-template name="display-bo-warning-message">
                <xsl:with-param name="titleI18nKey" select="'plugin.web:PLUGINS_WEB_SERVICE_USER_SIGNUP_VIEW_WARNINGS'"/>
                <xsl:with-param name="htmlMessage" select="$htmlMessage"/>
            </xsl:call-template>
        </xsl:if>
        
        <xsl:if test="$preview = 'true' and form/@hasEntries = 'true'">
            <xsl:variable name="htmlMessage">
                <i18n:text i18n:key="PLUGINS_FORMS_ALREADY_PUBLISHED_CONFIGURATION_WARNINGS_MSG"/>
            </xsl:variable>
                        
            <xsl:call-template name="display-bo-info-message">
                <xsl:with-param name="titleI18nKey" select="'plugin.forms:PLUGINS_FORMS_ALREADY_PUBLISHED_CONFIGURATION_WARNINGS'"/>
                <xsl:with-param name="htmlMessage" select="$htmlMessage"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="form-no-access">
        <xsl:if test="form/@hasReadAccess != 'true'">
            <i18n:text i18n:key="PLUGINS_FORMS_NO_ACCESS_ERROR"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="form-preview-go-to-page">
        <xsl:if test="$preview = 'true'">
            $j = jQuery.noConflict();
            function previewGotoPage(id, qId)
            {
                var pagePositions = {};
                // Hide all pages
                <xsl:for-each select="form/page">
                    pagePositions['<xsl:value-of select="@id"/>'] = '<xsl:value-of select="position()"/>';
                    // Hide page
                    $j("#form-<xsl:value-of select="$uniqueId"/>-page-<xsl:value-of select="position()"/>").hide();
                </xsl:for-each>
                
                // Show the current page
                if (id != null)
                {
                    $j("#form-<xsl:value-of select="$uniqueId"/>-page-" + pagePositions[id]).show();
                }
                else
                {
                    $j("#form-<xsl:value-of select="$uniqueId"/>-page-1").show();
                }
                
                if (qId != null)
                {
                    var qNames = {};
                    <xsl:for-each select="form//question">
                        qNames['<xsl:value-of select="@id"/>'] = '<xsl:value-of select="@name"/>';
                        $j("#form-<xsl:value-of select="$uniqueId"/>-q-<xsl:value-of select="@name"/>").removeClass("selected");
                    </xsl:for-each>
                    
                    // Select the current question
                    $j("#form-<xsl:value-of select="$uniqueId"/>-q-" + qNames[qId]).addClass("selected");
                    var offset = $j("#form-<xsl:value-of select="$uniqueId"/>-q-" + qNames[qId]).offset();
                    var top = offset &amp;&amp; offset.top;
                    
                    var wTop = window.scrollY;
                    var wBottom = window.innerHeight + window.scrollY;
                    
                    if (wTop > top || top > (wBottom - 50))
                    {
                        window.scrollTo(0, top);                    
                    }
                }
                
                if (pagePositions[id] != null)
                {
                    AmetysFormsHelper.handleSubmitButtons("<xsl:value-of select="$uniqueId"/>", pagePositions[id]);
                }
            }
            
            function selectQuestion(qName)
            {
                if (qName != null)
                {
                    <xsl:for-each select="form//question">
                        $j("#form-<xsl:value-of select="$uniqueId"/>-q-<xsl:value-of select="@name"/>").removeClass("selected");
                    </xsl:for-each>                    

                    // Select the current question
                    $j("#form-<xsl:value-of select="$uniqueId"/>-q-" + qName).addClass("selected");
                }
            }
            
            $j( document ).ready(function() {
                var formId = "<xsl:value-of select='form/@id' />";
    
                <xsl:if test="form/@currentPageId != ''">
                    previewGotoPage("<xsl:value-of select="form/@currentPageId" />", "<xsl:value-of select="form/@currentQuestionId" />");
                </xsl:if>
                parent.Ametys.plugins.forms.ui.UIFormQuestion.sendSelection(formId, "<xsl:value-of select="form/@currentPageId" />", "<xsl:value-of select="form/@currentQuestionId" />");
                
                
                var positions = {};
                <xsl:for-each select="form/page">
                    var pageId = "<xsl:value-of select='@id' />";
                    var pagePosition = "<xsl:value-of select="position()"/>";
                
                    var questionPositions = {};
                    positions[pageId] = questionPositions;
                    <xsl:if test="../@canWrite = 'true'">
                        var pageDivId = "#form-<xsl:value-of select="$uniqueId"/>-page-" + pagePosition + "-questions";
                        $j(pageDivId).sortable({
                            revert: true
                        });
                    </xsl:if>
                    
                    <xsl:for-each select="question">
                        questionPositions['<xsl:value-of select='@id' />'] = '<xsl:value-of select='position()' />'
                
                        $j("#form-<xsl:value-of select="$uniqueId"/>-q-<xsl:value-of select="@name"/>").click(function() {
                            var questionId = $j(this).attr("data-id");
                            var questionName = $j(this).attr("data-name");
                            var pageId = $j(this).attr("data-page-id");
                            selectQuestion(questionName)
                            parent.Ametys.plugins.forms.ui.UIFormQuestion.sendSelection(formId, pageId, questionId);
                        });
                     
                        <xsl:if test="../../@canWrite = 'true'">
                        $j("#form-<xsl:value-of select="$uniqueId"/>-q-<xsl:value-of select="@name"/>").draggable({
                            connectToSortable: pageDivId,
                            revert: "invalid",
                            stop: function(event, ui)
                            {
                                setTimeout(function(){
                                    var questionMovedId = $j(ui.helper[0]).attr("data-id");
                                    var questionPageId = $j(ui.helper[0]).attr("data-page-id");
                                    var questionPagePosition = $j(ui.helper[0]).attr("data-page-position");
                       
                                    var newPositions = {};
                                    var pageId = "#form-<xsl:value-of select="$uniqueId"/>-page-" + questionPagePosition + "-questions";
                                    $j(pageId).children().each(function( index ) {
                                        var id = $j(this).attr("data-id");
                                        newPositions[id] = index + 1;
                                    });
                             
                                    if (positions[questionPageId][questionMovedId] != newPositions[questionMovedId])
                                    {
                                        var newPosition = positions[questionPageId][questionMovedId] &lt; newPositions[questionMovedId] ? newPositions[questionMovedId] : newPositions[questionMovedId] - 1;
                                        parent.Ametys.plugins.forms.ui.UIFormQuestion.move(questionPageId, questionMovedId, newPosition);
                                    }
                                }, 1000);
                            }
                        })
                        </xsl:if>
                    </xsl:for-each>
                </xsl:for-each>
            });
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>