<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
    exclude-result-prefixes="ametys">

    <xsl:template match="question[@type = 'form.SimpleText']" mode="question-attribute-class">
        <xsl:attribute name="class">question question-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.SimpleText']" mode="read-only-value">
        <xsl:param name="value" />
        <xsl:value-of select="$value"/>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.SimpleText']" mode="render-mail">
        <xsl:call-template name="text.nl2br">
            <xsl:with-param name="input" select="value"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.SimpleText']" mode="input">
        <input type="text" name="{@name}" id="{@name}_{$uniqueId}" class="text" onchange="onSimpleTextChangeFunction_{translate(@name, '-', '_')}_{$uniqueId}()">
            <xsl:choose>
                <xsl:when test="entry-value/value">
                    <xsl:attribute name="value"><xsl:value-of select="entry-value/value"/></xsl:attribute>
                </xsl:when>
                <xsl:when test="additional-infos/default-value">
                    <xsl:attribute name="value"><xsl:value-of select="additional-infos/default-value"/></xsl:attribute>
                </xsl:when>
            </xsl:choose>
            <xsl:if test="placeholder">
                <xsl:attribute name="placeholder"><xsl:value-of select="placeholder"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="autocomplete">
                <xsl:attribute name="autocomplete"><xsl:value-of select="autocomplete/@value"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="mandatory = 'true'">
                <xsl:attribute name="aria-required">true</xsl:attribute>
            </xsl:if>
        </input>
    </xsl:template> 
    
    <xsl:template match="question[@type = 'form.SimpleText' and regexp and regexp/@value != ' ']" mode="check-regexp">
        var value = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>').val();
        if (value != '' &amp;&amp; !<xsl:value-of select="additional-infos/pattern"/>.test(value))
        {
            var msg = AmetysFormsHelper.getRegexpErrorMsg('<xsl:value-of select="regexp/@value"/>');
            AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', msg);
        }
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.SimpleText']" mode="init-rules">
        function onSimpleTextChangeFunction_<xsl:value-of select="translate(@name, '-', '_')" />_<xsl:value-of select="$uniqueId" />() {
            FormListenersHelper.executeListenerForInputs("<xsl:value-of select="$uniqueId" />", "<xsl:value-of select="../@number" />");
        }
    </xsl:template>
</xsl:stylesheet>