/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.content.data;

import java.util.Date;
import java.util.List;

import org.ametys.core.user.UserIdentity;

/**
 * User entry.
 */
public class UserEntry
{
    /** The entry id. */
    protected int _id;
    
    /** The entry submission date. */
    protected Date _creationDate;
    
    /** The user identity */
    protected UserIdentity _userIdentity;
    
    /** The entry values. */
    protected List<FieldValue> _values;
    
    /** The workflow id */
    protected Integer _workflowId;
    
    /**
     * Constructor with parameters.
     * @param id the id of the user entry
     * @param creationDate the creation date of the user entry
     * @param values the values of the user entry
     * @param workflowId the id of the workflow of this user entry
     * @param userIdentity the user identity. Can be null.
     */
    public UserEntry(int id, Date creationDate, List<FieldValue> values, Integer workflowId, UserIdentity userIdentity)
    {
        this._id = id;
        this._creationDate = creationDate;
        this._values = values;
        this._workflowId = workflowId;
        this._userIdentity = userIdentity;
    }

    /**
     * Get the id.
     * @return the id
     */
    public int getId()
    {
        return _id;
    }

    /**
     * Set the id.
     * @param id the id to set
     */
    public void setId(int id)
    {
        this._id = id;
    }

    /**
     * Get the creationDate.
     * @return the creationDate
     */
    public Date getCreationDate()
    {
        return _creationDate;
    }

    /**
     * Set the creationDate.
     * @param creationDate the creationDate to set
     */
    public void setCreationDate(Date creationDate)
    {
        this._creationDate = creationDate;
    }

    /**
     * Get the values.
     * @return the values
     */
    public List<FieldValue> getValues()
    {
        return _values;
    }

    /**
     * Set the values.
     * @param values the values to set
     */
    public void setValues(List<FieldValue> values)
    {
        this._values = values;
    }
    
    /**
     * Set the workflow id of this entry
     * @param workflowId the id of the workflow of this entry
     */
    public void setWorkflowId(Integer workflowId)
    {
        this._workflowId = workflowId;
    }
    
    /**
     * Get the workflow id of this user entry
     * @return the workflow id of this entry
     */
    public Integer getWorkflowId()
    {
        return _workflowId;
    }
    
    /**
     * Get the user identity of the entry
     * @return the user identity. Can be null.
     */
    public UserIdentity getUserIdentity()
    {
        return _userIdentity;
    }
    
}
