/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.actions;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.dao.FormDirectoryDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormDirectory;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GetFormsAction
extends ServiceableAction {
    protected CurrentUserProvider _userProvider;
    protected AmetysObjectResolver _resolver;
    protected FormDirectoryDAO _formDirectoryDAO;
    protected FormDAO _formDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._formDirectoryDAO = (FormDirectoryDAO)((Object)serviceManager.lookup(FormDirectoryDAO.ROLE));
        this._formDAO = (FormDAO)((Object)serviceManager.lookup(FormDAO.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        String profileId = (String)StringUtils.defaultIfEmpty((CharSequence)((String)jsParameters.get("profile")), (CharSequence)"read_access");
        if (!("read_access".equals(profileId) || "write_access".equals(profileId) || "right_access".equals(profileId))) {
            throw new IllegalArgumentException("Unexpected profile identifier : " + profileId);
        }
        Form.FormProfile profile = Form.FormProfile.valueOf(profileId.toUpperCase());
        FormDirectory parentDirectory = this._getParentDirectory(jsParameters);
        Boolean onlyDirectories = jsParameters.getOrDefault("onlyDirectories", Boolean.FALSE);
        Boolean onlyConfiguredForm = jsParameters.getOrDefault("onlyConfiguredForm", Boolean.FALSE);
        Boolean onlyForms = onlyDirectories != false ? false : jsParameters.getOrDefault("onlyForms", Boolean.FALSE);
        Boolean testIfEmptyDirectory = jsParameters.getOrDefault("testIfEmptyDirectory", Boolean.FALSE);
        Boolean allDescendants = jsParameters.getOrDefault("allDescendants", Boolean.FALSE);
        UserIdentity user = this._userProvider.getUser();
        ArrayList nodes = new ArrayList();
        Stream<Form> childFormsStream = onlyDirectories != false ? Stream.empty() : this._getChildForms(parentDirectory, allDescendants == false, profile, user).filter(f -> onlyConfiguredForm == false || this._formDAO.isFormConfigured((Form)((Object)f)));
        childFormsStream.map(f -> this._formDAO.getFormProperties((Form)((Object)f), false, false)).forEach(nodes::add);
        Stream<Pair> childDirectoriesStream = onlyForms != false ? Stream.empty() : this._getChildFormDirectories(parentDirectory, testIfEmptyDirectory, profile, user);
        childDirectoriesStream.forEach(p -> {
            Map<String, Object> props = this._formDirectoryDAO.getFormDirectoryProperties((FormDirectory)((Object)((Object)p.getLeft())), false);
            AdditionalInfoOnDirectory additionalInfo = (AdditionalInfoOnDirectory)p.getRight();
            additionalInfo.fillAdditionalInfo(props);
            switch (profile) {
                case WRITE_ACCESS: {
                    if (!((Boolean)props.get("displayForWrite")).booleanValue()) break;
                    nodes.add(props);
                    break;
                }
                case RIGHT_ACCESS: {
                    if (!((Boolean)props.get("displayForRights")).booleanValue()) break;
                    nodes.add(props);
                    break;
                }
                default: {
                    if (!((Boolean)props.get("displayForRead")).booleanValue()) break;
                    nodes.add(props);
                }
            }
        });
        HashMap result = new HashMap();
        result.put("forms", nodes);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private FormDirectory _getParentDirectory(Map jsParameters) {
        com.google.common.base.Predicate isNotRoot = Predicates.not((com.google.common.base.Predicate)Predicates.equalTo((Object)"root"));
        FormDirectory parent = Optional.of("node").map(jsParameters::get).filter(String.class::isInstance).map(String.class::cast).filter((Predicate<String>)isNotRoot).map(arg_0 -> ((AmetysObjectResolver)this._resolver).resolveById(arg_0)).orElse(this._formDirectoryDAO.getFormDirectoriesRootNode((String)jsParameters.get("siteName")));
        return parent;
    }

    private Stream<Pair<FormDirectory, AdditionalInfoOnDirectory>> _getChildFormDirectories(FormDirectory parentDirectory, boolean testIfEmptyDirectory, Form.FormProfile profile, UserIdentity user) {
        AmetysObjectIterable<FormDirectory> childFormDirectories = this._formDirectoryDAO.getChildFormDirectories(parentDirectory);
        Stream childFormDirectoriesStream = childFormDirectories.stream();
        if (testIfEmptyDirectory) {
            return childFormDirectoriesStream.map(ct -> Pair.of((Object)ct, (Object)new AdditionalInfoOnDirectory(this._hasNoDescendant((FormDirectory)((Object)ct), profile, user))));
        }
        return childFormDirectoriesStream.map(ct -> Pair.of((Object)ct, (Object)new AdditionalInfoOnDirectory()));
    }

    private Boolean _hasNoDescendant(FormDirectory formDirectory, Form.FormProfile profile, UserIdentity user) {
        boolean onlyDirectChildren = false;
        Stream<Form> childForms = this._getChildForms(formDirectory, onlyDirectChildren, profile, user);
        return !childForms.findAny().isPresent();
    }

    private Stream<Form> _getChildForms(FormDirectory parentDirectory, boolean onlyDirectChildren, Form.FormProfile profile, UserIdentity user) {
        return switch (profile) {
            case Form.FormProfile.WRITE_ACCESS -> this._formDirectoryDAO.getChildFormsInWriteAccess(parentDirectory, onlyDirectChildren, user);
            case Form.FormProfile.RIGHT_ACCESS -> this._formDirectoryDAO.getChildFormsInRightAccess(parentDirectory, onlyDirectChildren, user);
            default -> this._formDirectoryDAO.getChildFormsInReadAccess(parentDirectory, onlyDirectChildren, user);
        };
    }

    private static class AdditionalInfoOnDirectory {
        private Optional<Boolean> _hasNoDescendant = Optional.empty();

        AdditionalInfoOnDirectory() {
        }

        AdditionalInfoOnDirectory(boolean hasNoDescendant) {
            this._hasNoDescendant = Optional.of(hasNoDescendant);
        }

        void fillAdditionalInfo(Map<String, Object> props) {
            this._hasNoDescendant.ifPresent(b -> props.put("hasNoDescendantForm", b));
        }
    }
}

