/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.actions;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.right.RightManager;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetSubmissionAction
extends ServiceableAction {
    protected static FormTableManager _formTableManager;
    protected FormPropertiesManager _formPropertiesManager;
    protected RightManager _rightManager;

    public void service(ServiceManager smanager) throws ServiceException {
        _formTableManager = (FormTableManager)((Object)smanager.lookup(FormTableManager.ROLE));
        this._formPropertiesManager = (FormPropertiesManager)((Object)smanager.lookup(FormPropertiesManager.ROLE));
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
        super.service(smanager);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String formId = request.getParameter("formId");
        Content content = this._formPropertiesManager.getFormContent(formId);
        if (!this._rightManager.currentUserHasReadAccess((Object)content)) {
            throw new AccessDeniedException("Access denied to form " + formId);
        }
        int submissions = GetSubmissionAction.getTotalSubmissions(formId);
        result.put("submissions", Integer.valueOf(submissions));
        result.put("success", Boolean.valueOf(true));
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }

    public static int getTotalSubmissions(String formId) throws FormsException {
        return _formTableManager.getTotalSubmissions(formId);
    }
}

