/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.generators;

import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.helper.LimitedEntriesHelper;
import org.ametys.plugins.forms.helper.ScheduleOpeningHelper;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormPage;
import org.ametys.plugins.forms.repository.FormPageRule;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.forms.repository.type.Rule;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.model.type.DataContext;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormStructureGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _resolver;
    protected CurrentUserProvider _userProvider;
    protected I18nUtils _i18nUtils;
    protected LimitedEntriesHelper _limitedEntriesHelper;
    protected ScheduleOpeningHelper _scheduleOpeningHelper;
    protected FormDAO _formDAO;
    protected RightManager _rightManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._limitedEntriesHelper = (LimitedEntriesHelper)((Object)serviceManager.lookup(LimitedEntriesHelper.ROLE));
        this._scheduleOpeningHelper = (ScheduleOpeningHelper)((Object)serviceManager.lookup(ScheduleOpeningHelper.ROLE));
        this._formDAO = (FormDAO)((Object)serviceManager.lookup(FormDAO.ROLE));
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String id = this.parameters.getParameter("id", request.getParameter("id"));
        this.contentHandler.startDocument();
        UserIdentity user = this._userProvider.getUser();
        Form form = (Form)this._resolver.resolveById(id);
        boolean isPreview = StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("preview"), (CharSequence)"true");
        if (isPreview && !this._rightManager.hasReadAccess(user, (Object)form)) {
            throw new AccessDeniedException("User " + user.getLogin() + " tried to access form " + form.getId() + " without sufficient rights");
        }
        AttributesImpl attrs = new AttributesImpl();
        this._addFormLimitationAttributes(request, form, attrs);
        attrs.addCDATAAttribute("id", form.getId());
        attrs.addCDATAAttribute("name", form.getName());
        attrs.addCDATAAttribute("isPreview", String.valueOf(isPreview));
        if (isPreview) {
            attrs.addCDATAAttribute("currentPageId", request.getParameter("currentPageId"));
            attrs.addCDATAAttribute("currentQuestionId", request.getParameter("currentQuestionId"));
        }
        if (form.hasWorkflow()) {
            attrs.addCDATAAttribute("hasWorkflow", "true");
        }
        LocalDate startDate = form.getStartDate();
        LocalDate endDate = form.getEndDate();
        attrs.addCDATAAttribute("scheduleStatus", this._scheduleOpeningHelper.getStatus(form).name());
        if (startDate != null) {
            attrs.addCDATAAttribute("startDate", DateUtils.localDateToString((LocalDate)startDate));
        }
        if (endDate != null) {
            attrs.addCDATAAttribute("endDate", DateUtils.localDateToString((LocalDate)endDate));
        }
        attrs.addCDATAAttribute("isConfigured", String.valueOf(this._formDAO.isFormConfigured(form)));
        attrs.addCDATAAttribute("hasReadAccess", String.valueOf(this._formDAO.hasReadRightOnForm(user, form)));
        attrs.addCDATAAttribute("canWrite", String.valueOf(this._formDAO.hasWriteRightOnForm(user, (AmetysObject)form)));
        if (form.isMiniSurvey()) {
            attrs.addCDATAAttribute("isMiniSurvey", "true");
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"form", (Attributes)attrs);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)form.getTitle());
        int pageNumber = 1;
        for (FormPage page : form.getPages()) {
            if (page.getQuestions().isEmpty()) continue;
            this.saxPage(page, pageNumber);
            ++pageNumber;
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"form");
        this.contentHandler.endDocument();
    }

    protected void _addFormLimitationAttributes(Request request, Form form, AttributesImpl attrs) {
        UserIdentity currentUser = this._userProvider.getUser();
        String clientIp = this._limitedEntriesHelper.getClientIp(request);
        Optional<Long> maxEntriesOpt = form.getMaxEntries();
        boolean isClosed = false;
        attrs.addCDATAAttribute("isLimitedToOneEntryByUser", String.valueOf(form.isLimitedToOneEntryByUser()));
        attrs.addCDATAAttribute("hasEntries", String.valueOf(!form.getEntries().isEmpty()));
        if (form.isLimitedToOneEntryByUser() && this._limitedEntriesHelper.hasUserAlreadyAnswer(form, currentUser, clientIp)) {
            isClosed = true;
            attrs.addCDATAAttribute("user-already-answer", "true");
        } else if (form.isEntriesLimited() && maxEntriesOpt.isPresent()) {
            Long maxEntries = maxEntriesOpt.get();
            int entriesCount = form.getActiveEntries().size();
            Optional<Long> queueSize = form.getQueueSize();
            if ((long)entriesCount < maxEntries) {
                String remainingMessage = form.getRemainingMessage().get();
                remainingMessage = remainingMessage.replace("{remaining}", String.valueOf(maxEntries - (long)entriesCount));
                remainingMessage = remainingMessage.replace("{submissions}", String.valueOf(entriesCount));
                remainingMessage = remainingMessage.replace("{limit}", String.valueOf(maxEntries));
                attrs.addCDATAAttribute("limit-text", remainingMessage);
            } else if (form.isQueueEnabled() && (queueSize.isEmpty() || (long)entriesCount < maxEntries + queueSize.get())) {
                String queueMessage = form.getClosedQueueMessage().get();
                queueMessage = queueMessage.replace("{inwaiting}", String.valueOf((long)entriesCount - maxEntries + 1L));
                if (queueSize.isPresent()) {
                    queueMessage = queueMessage.replace("{limit}", String.valueOf(queueSize.get()));
                }
                attrs.addCDATAAttribute("limit-text", queueMessage);
            } else {
                isClosed = true;
                String closedMessage = form.getClosedMessage().get();
                attrs.addCDATAAttribute("limit-text", closedMessage);
            }
        }
        attrs.addCDATAAttribute("isClosed", String.valueOf(isClosed));
    }

    protected void saxPage(FormPage page, int pageNumber) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", page.getId());
        attrs.addCDATAAttribute("name", page.getName());
        attrs.addCDATAAttribute("number", String.valueOf(pageNumber));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"page", (Attributes)attrs);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)page.getTitle());
        for (FormQuestion question : page.getQuestions()) {
            this.saxQuestion(question);
        }
        this.saxBranches(page);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"page");
    }

    protected void saxQuestion(FormQuestion question) throws SAXException {
        FormQuestionType type = question.getType();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("canRead", String.valueOf(question.canRead(0L)));
        attrs.addCDATAAttribute("canWrite", String.valueOf(question.canWrite(0L)));
        attrs.addCDATAAttribute("type", type.getId());
        if (!type.onlyForDisplay(question)) {
            attrs.addCDATAAttribute("storageType", type.getStorageType(question));
        }
        attrs.addCDATAAttribute("id", question.getId());
        attrs.addCDATAAttribute("name", question.getNameForForm());
        Optional<Rule> questionRule = question.getFirstQuestionRule();
        if (questionRule.isPresent()) {
            Rule rule = questionRule.get();
            String action = rule.getAction().name();
            attrs.addCDATAAttribute("status", action);
        }
        attrs.addCDATAAttribute("onlyForDisplay", String.valueOf(type.onlyForDisplay(question)));
        attrs.addCDATAAttribute("canBeAnsweredByUser", String.valueOf(type.canBeAnsweredByUser(question)));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"question", (Attributes)attrs);
        RepositoryDataContext context = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)question);
        question.dataToSAX(this.contentHandler, (DataContext)context);
        Map<String, Rule> questionsRules = question.getForm().getQuestionsRule(question.getId()).entrySet().stream().collect(Collectors.toMap(e -> ((FormQuestion)((Object)((Object)e.getKey()))).getNameForForm(), e -> (Rule)e.getValue()));
        this.saxQuestionRules(questionsRules);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"additional-infos");
        type.saxAdditionalInfos(this.contentHandler, question);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"additional-infos");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"question");
    }

    protected void saxBranches(FormPage page) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"branches");
        List<FormQuestion> questions = page.getQuestions();
        for (FormQuestion question : questions) {
            List<FormPageRule> rules = question.getPageRules();
            for (FormPageRule rule : rules) {
                AttributesImpl attr = new AttributesImpl();
                attr.addCDATAAttribute("id", question.getId());
                attr.addCDATAAttribute("name", question.getNameForForm());
                attr.addCDATAAttribute("value", rule.getOption());
                FormPageRule.PageRuleType type = rule.getType();
                attr.addCDATAAttribute("type", type.name());
                if (type == FormPageRule.PageRuleType.JUMP) {
                    attr.addCDATAAttribute("page", rule.getPageId());
                }
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"rule", (Attributes)attr);
            }
        }
        FormPageRule rule = page.getRule();
        if (rule != null) {
            AttributesImpl attr = new AttributesImpl();
            FormPageRule.PageRuleType type = rule.getType();
            attr.addCDATAAttribute("type", type.name());
            if (type == FormPageRule.PageRuleType.JUMP) {
                attr.addCDATAAttribute("page", rule.getPageId());
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"page-rule", (Attributes)attr);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"branches");
    }

    protected void saxQuestionRules(Map<String, Rule> rules) throws SAXException {
        if (!rules.isEmpty()) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"rules");
            for (String targetNameForForm : rules.keySet()) {
                AttributesImpl attr = new AttributesImpl();
                attr.addCDATAAttribute("target-name", targetNameForForm);
                attr.addCDATAAttribute("action", rules.get(targetNameForForm).getAction().name());
                attr.addCDATAAttribute("value", rules.get(targetNameForForm).getOption());
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"rule", (Attributes)attr);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"rules");
        }
    }
}

