/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.validators;

import java.util.Collections;
import org.ametys.cms.data.Binary;
import org.ametys.plugins.repository.data.holder.values.UntouchedValue;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.commons.lang3.StringUtils;

public class FileFormValidator
extends DefaultValidator {
    protected Long _max;
    protected String _extensions;

    public FileFormValidator(String regexp, boolean mandatory, Long max, String extensions) {
        super(regexp, mandatory);
        this._max = max;
        this._extensions = extensions;
    }

    protected ValidationResult validateSingleValue(Object value) {
        if (value instanceof UntouchedValue) {
            return ValidationResult.empty();
        }
        ValidationResult result = super.validateSingleValue(value);
        if (value != null) {
            float maxLength;
            Binary file = (Binary)value;
            if (StringUtils.isNotBlank((CharSequence)this._extensions)) {
                String[] fileExtArray = this._extensions.split(",");
                boolean extensionOk = false;
                for (int i = 0; i < fileExtArray.length && !extensionOk; ++i) {
                    String ext = fileExtArray[i].trim().toLowerCase();
                    extensionOk = file.getName().toLowerCase().endsWith(ext);
                }
                if (!extensionOk) {
                    result.addError(new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_EXTENSION"));
                }
            }
            if ((maxLength = (float)this._max.longValue()) < Float.MAX_VALUE) {
                maxLength = maxLength * 1024.0f * 1024.0f;
            }
            if ((float)file.getLength() > maxLength) {
                result.addError(new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_TOOLARGE", Collections.singletonList(this._max.toString() + "Mo")));
            }
        }
        return result;
    }

    protected ValidationResult validateArrayValues(Object[] values) {
        ValidationResult result = super.validateArrayValues(values);
        for (Object valueToValidate : values) {
            result.addResult(this.validateSingleValue(valueToValidate));
        }
        return result;
    }
}

