/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.validators;

import java.util.HashMap;
import org.ametys.plugins.forms.question.validators.AbstractIntervalFormValidator;
import org.ametys.runtime.i18n.I18nizableText;

public class NumberIntervalFormValidator
extends AbstractIntervalFormValidator<Number> {
    public NumberIntervalFormValidator(String regexp, boolean mandatory, Number min, Number max) {
        super(regexp, mandatory, min, max);
    }

    @Override
    protected boolean isLessThan(Number value, Number min) {
        return value.doubleValue() < min.doubleValue();
    }

    @Override
    protected boolean isMoreThan(Number value, Number max) {
        return value.doubleValue() > max.doubleValue();
    }

    @Override
    protected I18nizableText getIntervalError(Number min, Number max) {
        HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
        i18nParams.put("minValue", new I18nizableText(min.toString()));
        i18nParams.put("maxValue", new I18nizableText(max.toString()));
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_ENTRY_VALIDATOR_NUMBER_INTERVAL_ERROR", i18nParams);
    }
}

