/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.repository;

import java.util.List;
import org.ametys.plugins.forms.repository.AbstractFormCopyUpdater;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormPage;
import org.ametys.plugins.forms.repository.FormPageRule;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.apache.commons.lang3.StringUtils;

public class FormPageRuleCopyUpdater
extends AbstractFormCopyUpdater {
    @Override
    public void updateForm(Form originalForm, Form createdForm) {
        boolean hasChanges = false;
        for (FormPage originalFormPage : originalForm.getPages()) {
            hasChanges = this._updateFormPagePageRule(createdForm, originalFormPage) || hasChanges;
            for (FormQuestion originalFormQuestion : originalFormPage.getQuestions()) {
                FormQuestion copiedQuestion;
                hasChanges = this._updateFormQuestionPageRules(createdForm, originalFormQuestion, copiedQuestion = this._getCopiedQuestion(createdForm, originalFormQuestion)) || hasChanges;
            }
        }
        if (hasChanges) {
            createdForm.saveChanges();
        }
    }

    private boolean _updateFormPagePageRule(Form createdForm, FormPage originalFormPage) {
        if (originalFormPage.hasRule()) {
            FormPageRule rule = originalFormPage.getRule();
            FormPage copiedRuleTargetPage = this._getCopiedRuleTargetPage(createdForm, rule.getPageId());
            FormPage copiedPage = this._getCopiedPage(createdForm, originalFormPage);
            copiedPage.setRule(rule.getType(), copiedRuleTargetPage != null ? copiedRuleTargetPage.getId() : null);
            return true;
        }
        return false;
    }

    private boolean _updateFormQuestionPageRules(Form createdForm, FormQuestion originalFormQuestion, FormQuestion copiedQuestion) {
        List<FormPageRule> pageRules = originalFormQuestion.getPageRules();
        for (FormPageRule rule : pageRules) {
            FormPage copiedTargetPage = this._getCopiedRuleTargetPage(createdForm, rule.getPageId());
            copiedQuestion.addPageRules(rule.getOption(), rule.getType(), copiedTargetPage != null ? copiedTargetPage.getId() : null);
        }
        return pageRules.size() > 0;
    }

    private FormPage _getCopiedRuleTargetPage(Form createdForm, String originalPageId) {
        if (StringUtils.isNotBlank((CharSequence)originalPageId)) {
            FormPage originalPage = (FormPage)this._resolver.resolveById(originalPageId);
            return this._getCopiedPage(createdForm, originalPage);
        }
        return null;
    }

    @Override
    public void updateFormPage(FormPage originalFormPage, FormPage createdFormPage) {
    }

    @Override
    public void updateFormQuestion(FormQuestion originalFormQuestion, FormQuestion createdFormQuestion) {
    }
}

