/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import com.google.javascript.jscomp.jarjar.com.google.re2j.Pattern;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import jakarta.mail.MessagingException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.File;
import org.ametys.cms.data.holder.DataHolderRelativeDisableCondition;
import org.ametys.cms.data.holder.DataHolderRelativeDisableConditions;
import org.ametys.cms.data.holder.DataHolderRelativeDisableConditionsHelper;
import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.right.Right;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.helper.FormMailHelper;
import org.ametys.plugins.forms.helper.MailVariableParser;
import org.ametys.plugins.forms.question.types.impl.FileQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.forms.workflow.WorkflowFormMailExtensionPoint;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.plugins.workflow.component.WorkflowArgument;
import org.ametys.plugins.workflow.support.WorkflowElementDefinitionHelper;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class WorkflowFormSendMailFunction
extends AbstractLogEnabled
implements Component,
EnhancedFunction,
Serviceable,
Contextualizable {
    public static final String ROLE = WorkflowFormSendMailFunction.class.getName();
    public static final String FUNCTION_PARAM_PREFIX = ROLE + "-";
    public static final String FORM_DASHBOARD_ADMIN = "form.dashboardAdmin";
    public static final String FORM_DASHBOARD = "form.dashboard";
    public static final String ENTRY_NUMBER = "entryNumber";
    public static final String FORM_TITLE = "form.title";
    public static final String ENTRY = "entry.";
    public static final String USER = "user";
    public static final String ARG_SENDER = "sender";
    public static final String ARG_RECIPIENT = "recipient";
    public static final String ARG_MANUAL_RECIPIENT = "manual-recipient";
    public static final String ARG_RIGHTS_RECIPIENT = "right-recipient";
    public static final String ARG_GROUP_RECIPIENT = "group-recipient";
    public static final String FORMS_RIGHTS_CATEGORY = "plugin.forms:FORMS_DEFAULT_WORKFLOW_ENTRY_RIGHTS_CATEGORY";
    public static final String ARG_SUBJECT = "subject";
    public static final String ARG_BODY = "body";
    public static final String ARG_LINK = "link";
    public static final String ARG_ENTRY_DETAIL = "entry-detail";
    public static final String ARG_COMMENT = "comment";
    public static final String IGNORE_RIGHT_KEY = "ignore-right";
    private static final String __USER_GROUP_RECIPIENT_ARG = "user-group";
    private static final String __MANUAL_RECIPIENT_ARG = "manual";
    private static final String __RIGHTS_RECIPIENT_ARG = "rights";
    private static final String __USER_RECIPIENT_ARG = "user";
    private static final String __REGEX_EMAIL = "^([a-zA-Z0-9_\\.\\-\\+])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$";
    private static final String __SUBMISSIONS = "submissions";
    private static final String __DASHBOARD = "dashboard";
    private static final String __WITH_RESTRICTION = "with-restriction";
    private static final String __WITHOUT_RESTRICTION = "without-restriction";
    private static final String __NO_DATA = "no-data";
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;
    protected SourceResolver _sourceResolver;
    protected Context _context;
    protected FormDAO _formDAO;
    protected I18nUtils _i18nUtils;
    protected WorkflowFormMailExtensionPoint _workflowFormMailEP;
    protected MailVariableParser _mailVariableParser;
    protected FormMailHelper _formMailHelper;
    protected RightsExtensionPoint _rightsExtensionPoint;
    protected RightManager _rightManager;
    protected GroupDirectoryDAO _groupDirectoryDAO;
    protected DataHolderRelativeDisableConditionsHelper _disableConditionsHelper;
    protected List<SendMailHelper.NamedStream> _mailAttachments;

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._workflowFormMailEP = (WorkflowFormMailExtensionPoint)((Object)manager.lookup(WorkflowFormMailExtensionPoint.ROLE));
        this._mailVariableParser = (MailVariableParser)((Object)manager.lookup(MailVariableParser.ROLE));
        this._formMailHelper = (FormMailHelper)((Object)manager.lookup(FormMailHelper.ROLE));
        this._rightsExtensionPoint = (RightsExtensionPoint)manager.lookup(RightsExtensionPoint.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._groupDirectoryDAO = (GroupDirectoryDAO)manager.lookup(GroupDirectoryDAO.ROLE);
        this._disableConditionsHelper = (DataHolderRelativeDisableConditionsHelper)manager.lookup(DataHolderRelativeDisableConditionsHelper.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        this._mailAttachments = new ArrayList<SendMailHelper.NamedStream>();
        FormEntry formEntry = (FormEntry)((Object)transientVars.get(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY));
        String sender = this._getSender(formEntry, transientVars, args);
        List<String> recipients = this._getRecipients(formEntry, transientVars, args);
        try {
            String subject = this._getSubject(formEntry, transientVars, args);
            String body = this._getBody(formEntry, transientVars, args, subject);
            Collection<SendMailHelper.NamedStream> records = this._getMailAttachments(formEntry, args);
            try {
                for (String recipient : recipients) {
                    try {
                        SendMailHelper.MailBuilder mailBuilder = SendMailHelper.newMail().withAsync(true).withSubject(subject).withHTMLBody(body).withSender(sender).withRecipient(recipient);
                        if (!records.isEmpty()) {
                            mailBuilder = mailBuilder.withAttachmentsAsStream(records);
                        }
                        mailBuilder.sendMail();
                    }
                    catch (MessagingException | IOException e) {
                        this.getLogger().warn("Could not send a workflow notification mail to " + recipient, e);
                    }
                }
            }
            catch (Throwable throwable) {
                for (SendMailHelper.NamedStream record : records) {
                    IOUtils.close((Closeable)record.inputStream());
                }
                throw throwable;
            }
            for (SendMailHelper.NamedStream record : records) {
                IOUtils.close((Closeable)record.inputStream());
            }
        }
        catch (IOException e) {
            this.getLogger().warn("Could not send a workflow notification mail", (Throwable)e);
        }
    }

    protected Collection<SendMailHelper.NamedStream> _getMailAttachments(FormEntry formEntry, Map args) {
        String entryDetail;
        switch (entryDetail = this._getStringParam(args, ARG_ENTRY_DETAIL)) {
            case "no-data": {
                return this._mailAttachments;
            }
            case "with-restriction": {
                return CollectionUtils.union(this._formMailHelper.getEntryFiles(formEntry.getForm(), formEntry, false, true), this._mailAttachments);
            }
        }
        return this._formMailHelper.getEntryFiles(formEntry.getForm(), formEntry, false, false);
    }

    protected String _getSender(FormEntry formEntry, Map transientVars, Map args) {
        String sender = this._getStringParam(args, ARG_SENDER);
        String senderMail = this._replaceText(sender, var -> this._getReplacedAttribute(formEntry, (String)var, true));
        String stripedEmail = StringUtils.trim((String)senderMail);
        if (StringUtils.isBlank((CharSequence)stripedEmail) || !Pattern.matches((String)__REGEX_EMAIL, (CharSequence)stripedEmail)) {
            this.getLogger().error("An error occured because email sender is invalid: '" + stripedEmail + "'. The configuration for sender '" + sender + "' must match with an unique email address");
        }
        return stripedEmail;
    }

    protected List<String> _getRecipients(FormEntry formEntry, Map transientVars, Map args) {
        String recipient;
        ArrayList<String> emailAdresses = new ArrayList<String>();
        switch (recipient = this._getStringParam(args, ARG_RECIPIENT)) {
            case "manual": {
                emailAdresses.addAll(this._getManualEmails(formEntry, args));
                break;
            }
            case "rights": {
                emailAdresses.addAll(this._getEmailsFromRights(formEntry, args));
                break;
            }
            case "user-group": {
                emailAdresses.addAll(this._getEmailsFromGroup(args));
                break;
            }
            default: {
                emailAdresses.add(this._getSubmitterValue(formEntry, true));
            }
        }
        return emailAdresses;
    }

    protected List<String> _getEmailsFromGroup(Map args) {
        ArrayList<String> emailAdresses = new ArrayList<String>();
        String recipientGroupValue = this._getStringParam(args, ARG_GROUP_RECIPIENT);
        GroupIdentity groupIdentity = GroupIdentity.stringToGroupIdentity((String)recipientGroupValue);
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupIdentity.getDirectoryId());
        if (groupDirectory != null) {
            Group group = groupDirectory.getGroup(groupIdentity.getId());
            for (UserIdentity userIdentity : group.getUsers()) {
                User user = this._userManager.getUser(userIdentity);
                if (user == null) continue;
                emailAdresses.add(user.getEmail());
            }
        }
        return emailAdresses;
    }

    protected List<String> _getManualEmails(FormEntry formEntry, Map args) {
        ArrayList<String> emailAdresses = new ArrayList<String>();
        String recipientManualValue = this._getStringParam(args, ARG_MANUAL_RECIPIENT);
        String email = this._replaceText(recipientManualValue, var -> this._getReplacedAttribute(formEntry, (String)var, true));
        if (StringUtils.isNotBlank((CharSequence)email)) {
            String[] emails;
            for (String mail : emails = StringUtils.split((String)email, (String)",")) {
                String stripedEmail = StringUtils.trim((String)mail);
                if (StringUtils.isBlank((CharSequence)stripedEmail) || !Pattern.matches((String)__REGEX_EMAIL, (CharSequence)stripedEmail)) {
                    this.getLogger().error("An error occured because email recipient value is invalid: '" + stripedEmail + "'. The configuration for recipient '" + recipientManualValue + "' must match with an unique email address");
                    continue;
                }
                emailAdresses.add(stripedEmail);
            }
        } else {
            this.getLogger().error("An error occured because email recipient value is invalid: '" + email + "'. The configuration for recipient '" + recipientManualValue + "' must match with an unique email address");
        }
        return emailAdresses;
    }

    protected List<String> _getEmailsFromRights(FormEntry formEntry, Map args) {
        Form form = formEntry.getForm();
        String[] rights = this._getStringParam(args, ARG_RIGHTS_RECIPIENT).split(",");
        Set<UserIdentity> users = this._getUsersFromRights(form, new HashSet<String>(Arrays.asList(rights)));
        return users.stream().map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).filter(Objects::nonNull).map(User::getEmail).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    protected Set<UserIdentity> _getUsersFromRights(Form form, Set<String> rights) {
        HashSet<UserIdentity> users = new HashSet<UserIdentity>();
        Iterator<String> rightIt = rights.iterator();
        if (rightIt.hasNext()) {
            users.addAll(this._rightManager.getAllowedUsers(StringUtils.trim((String)rightIt.next()), (Object)form).resolveAllowedUsers(((Boolean)Config.getInstance().getValue("runtime.mail.massive.sending")).booleanValue()));
        }
        while (rightIt.hasNext()) {
            users.retainAll(this._rightManager.getAllowedUsers(StringUtils.trim((String)rightIt.next()), (Object)form).resolveAllowedUsers(((Boolean)Config.getInstance().getValue("runtime.mail.massive.sending")).booleanValue()));
        }
        return users;
    }

    protected String _getSubject(FormEntry formEntry, Map transientVars, Map args) {
        String subject = this._getStringParam(args, ARG_SUBJECT);
        return this._replaceText(subject, var -> this._getReplacedAttribute(formEntry, (String)var, false));
    }

    protected String _getBody(FormEntry formEntry, Map transientVars, Map args, String subject) throws IOException {
        String lang = this._formDAO.getFormLocale(formEntry.getForm());
        String comment = this._getStringParam(transientVars, ARG_COMMENT);
        String link = this._getStringParam(args, ARG_LINK);
        String entryDetail = this._getStringParam(args, ARG_ENTRY_DETAIL);
        String body = this._getStringParam(args, ARG_BODY);
        body = this._replaceText(body, var -> this._getReplacedAttribute(formEntry, (String)var, false));
        StandardMailBodyHelper.MailBodyBuilder mailBody = StandardMailBodyHelper.newHTMLBody().withLanguage(lang).withTitle(subject).withMessage(body);
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(comment);
            UserIdentity userIdentity = this._currentUserProvider.getUser();
            mailBody.withUserInputs(List.of(new StandardMailBodyHelper.MailBodyBuilder.UserInput(this._userManager.getUser(userIdentity), ZonedDateTime.now(), (Object)comment.replaceAll("\r?\n", "<br/>"))));
        }
        if (!StringUtils.equals((CharSequence)entryDetail, (CharSequence)__NO_DATA)) {
            String entryDetails = this._formMailHelper.getMail("entry.html", formEntry, Map.of(), StringUtils.equals((CharSequence)entryDetail, (CharSequence)__WITH_RESTRICTION));
            mailBody.withDetails(new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_RESULTS_DETAILS_TITLE"), entryDetails, false);
        }
        if (StringUtils.isNotEmpty((CharSequence)link)) {
            Form form = formEntry.getForm();
            String siteName = form.getSiteName();
            String linkUrl = link.equals(__DASHBOARD) ? this._formDAO.getAdminDashboardUri(siteName) : this._formDAO.getDashboardUri(siteName);
            I18nizableText linkLabel = link.equals(__DASHBOARD) ? new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_DASHBOARD_LABEL") : new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_SUBMISSIONS_LABEL");
            mailBody.withLink(linkUrl, linkLabel);
        }
        return mailBody.build();
    }

    private String _replaceText(String expression, Function<String, String> function) {
        String replacedText = "";
        try {
            replacedText = this._mailVariableParser.replaceText(expression, function);
        }
        catch (PatternException e) {
            this.getLogger().error("Couldn't use arguments for sending email, variable  was not correctly written", (Throwable)e);
        }
        return StringUtils.isNotBlank((CharSequence)replacedText) ? replacedText : "";
    }

    protected String _getReplacedAttribute(FormEntry formEntry, String attribute, Boolean isMailAddress) {
        Form form = formEntry.getForm();
        String siteName = form.getSiteName();
        return switch (attribute) {
            case "user" -> this._getSubmitterValue(formEntry, isMailAddress);
            case FORM_TITLE -> this._getFormTitle(form);
            case FORM_DASHBOARD -> this._getDashboardUri(siteName);
            case FORM_DASHBOARD_ADMIN -> this._getAdminDashboardUri(siteName);
            case ENTRY_NUMBER -> this._getEntryNumber(formEntry);
            default -> attribute.startsWith(ENTRY) ? this._getFormEntryAttributeValue(formEntry, attribute, isMailAddress) : null;
        };
    }

    protected void _addFileToAttachments(FormEntry formEntry, String attribute) {
        File file;
        FormQuestion question = formEntry.getForm().getQuestion(attribute);
        if (question.getType() instanceof FileQuestionType && (file = (File)formEntry.getValue(attribute)) != null) {
            this._mailAttachments.add(new SendMailHelper.NamedStream(file.getInputStream(), file.getName(), file.getMimeType()));
        }
    }

    protected String _getEntryNumber(FormEntry formEntry) {
        return String.valueOf(formEntry.getEntryId());
    }

    protected String _getFormEntryAttributeValue(FormEntry formEntry, String attribute, Boolean isMailAddress) {
        String replacedAttribute = null;
        String attributeCloned = attribute.replace(ENTRY, "");
        String[] attributes = attributeCloned.split("\\.");
        String questionName = attributes[0];
        if (StringUtils.isNotBlank((CharSequence)questionName) && formEntry.hasDefinition(questionName)) {
            if (attributes.length == 1) {
                if (isMailAddress.booleanValue() && formEntry.getType(questionName).getId().equals("user")) {
                    UserIdentity userId = (UserIdentity)formEntry.getValue(questionName);
                    User contentUser = userId != null ? this._userManager.getUser(userId) : null;
                    replacedAttribute = contentUser != null ? contentUser.getEmail() : "";
                } else {
                    replacedAttribute = this.getFormQuestionMailValue(formEntry, questionName);
                    this._addFileToAttachments(formEntry, questionName);
                }
            } else if (attributes.length > 1) {
                replacedAttribute = this._getFormStringContentValue(formEntry, attributes, questionName);
            }
        }
        return replacedAttribute;
    }

    protected String _getFormStringContentValue(FormEntry formEntry, String[] attributes, String questionName) {
        String replacedAttribute = "";
        if (formEntry.getType(questionName).getId().equals("content")) {
            String path = String.join((CharSequence)"/", Arrays.copyOfRange(attributes, 1, attributes.length));
            if (formEntry.isMultiple(questionName)) {
                ContentValue[] values = (ContentValue[])formEntry.getValue(questionName, false, new ContentValue[0]);
                ArrayList<String> valuesToJoin = new ArrayList<String>();
                for (ContentValue value : values) {
                    String attributeValue = this._getStringAttributeValue(path, value);
                    if (!StringUtils.isNotBlank((CharSequence)attributeValue)) continue;
                    valuesToJoin.add(attributeValue);
                }
                replacedAttribute = String.join((CharSequence)", ", valuesToJoin);
            } else {
                ContentValue value = (ContentValue)formEntry.getValue(questionName);
                replacedAttribute = this._getStringAttributeValue(path, value);
            }
        }
        return replacedAttribute;
    }

    protected String _getAdminDashboardUri(String siteName) {
        return this._formDAO.getAdminDashboardUri(siteName);
    }

    protected String _getDashboardUri(String siteName) {
        return this._formDAO.getDashboardUri(siteName);
    }

    protected String _getFormTitle(Form form) {
        return form.getTitle();
    }

    protected String _getSubmitterValue(FormEntry formEntry, Boolean isMailAddress) {
        User user;
        UserIdentity userIdentity = formEntry.getUser();
        User user2 = user = userIdentity != null ? this._userManager.getUser(userIdentity) : null;
        return user != null ? (isMailAddress.booleanValue() ? user.getEmail() : user.getFullName()) : "";
    }

    protected String _getStringAttributeValue(String path, ContentValue value) {
        if (value.hasDefinition(path) && value.getType(path).getId().equals("string")) {
            return !value.isMultiple(path) ? (String)value.getValue(path) : this._getMultipleValue(value, path);
        }
        return "";
    }

    protected String _getMultipleValue(ContentValue value, String path) {
        CharSequence[] values = (String[])value.getValue(path, true);
        return values != null ? String.join((CharSequence)", ", values) : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormQuestionMailValue(FormEntry entry, String questionName) {
        String string;
        Source src = null;
        Request request = ContextHelper.getRequest((Context)this._context);
        Form form = entry.getForm();
        try {
            request.setAttribute(IGNORE_RIGHT_KEY, (Object)true);
            String uri = "cocoon:/mail/entry/render-mail.html";
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("formId", form.getId());
            parameters.put("entryId", entry.getId());
            parameters.put("questionName", questionName);
            src = this._sourceResolver.resolveURI(uri, null, parameters);
            InputStreamReader reader = new InputStreamReader(src.getInputStream(), "UTF-8");
            string = IOUtils.toString((Reader)reader);
            request.setAttribute(IGNORE_RIGHT_KEY, (Object)false);
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while saxxing question " + questionName + " in current entry", (Throwable)e);
            String string2 = null;
            return string2;
        }
        finally {
            request.setAttribute(IGNORE_RIGHT_KEY, (Object)false);
            this._sourceResolver.release(src);
        }
        this._sourceResolver.release(src);
        return string;
    }

    protected String _getStringParam(Map args, String key) {
        Object object = args.get(key);
        return object != null ? (String)object : "";
    }

    public EnhancedFunction.FunctionType getFunctionExecType() {
        return EnhancedFunction.FunctionType.POST;
    }

    public List<WorkflowArgument> getArguments() {
        return List.of(this._getSenderArgument(), this._getRecipientTypeArgument(), this._getManualRecipientArgument(), this._getGroupRecipient(), this._getRightsRecipientArgument(), this._getSubjectArgument(), this._getBodyArgument(), this._getEntryDetailArgument(), this._getLinkArgument());
    }

    private WorkflowArgument _getGroupRecipient() {
        WorkflowArgument groupRecipient = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_GROUP_RECIPIENT, (I18nizableText)new I18nizableText(""), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_GROUP_FIELD_DESCRIPTION"), (boolean)true, (boolean)false);
        StaticEnumerator groupStaticEnumerator = new StaticEnumerator();
        for (GroupDirectory groupDirectory : this._groupDirectoryDAO.getGroupDirectories()) {
            I18nizableText groupDirectoryLabel = groupDirectory.getLabel();
            for (Group group : groupDirectory.getGroups()) {
                String groupLabel = group.getLabel();
                String groupIdentity = GroupIdentity.groupIdentityToString((GroupIdentity)group.getIdentity());
                Map<String, I18nizableText> params = Map.of("directory", groupDirectoryLabel, "group", new I18nizableText(groupLabel));
                groupStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_GROUP_KEY_PARAMS_LABEL", params), (Object)groupIdentity);
            }
        }
        HashMap<String, I18nizableText> widgetParameters = new HashMap<String, I18nizableText>();
        widgetParameters.put("emptyText", new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_GROUP_FIELD_PLACEHOLDER"));
        groupRecipient.setWidgetParameters(widgetParameters);
        groupRecipient.setEnumerator((Enumerator)groupStaticEnumerator);
        DataHolderRelativeDisableConditions groupDisableConditions = new DataHolderRelativeDisableConditions();
        DataHolderRelativeDisableCondition groupCondition = new DataHolderRelativeDisableCondition(this._getFunctionArgumentPrefix() + ARG_RECIPIENT, DisableCondition.OPERATOR.NEQ, __USER_GROUP_RECIPIENT_ARG, this._disableConditionsHelper);
        groupDisableConditions.getConditions().add(groupCondition);
        groupRecipient.setDisableConditions((DisableConditions)groupDisableConditions);
        return groupRecipient;
    }

    private WorkflowArgument _getRightsRecipientArgument() {
        WorkflowArgument rightsRecipient = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_RIGHTS_RECIPIENT, (I18nizableText)new I18nizableText(""), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_RIGHT_FIELD_DESCRIPTION"), (boolean)true, (boolean)false);
        StaticEnumerator rightsStaticEnumerator = new StaticEnumerator();
        for (String rightId : this._rightsExtensionPoint.getExtensionsIds()) {
            Right right = this._rightsExtensionPoint.getExtension(rightId);
            if (!FORMS_RIGHTS_CATEGORY.equals(right.getCategory().toString())) continue;
            rightsStaticEnumerator.add(right.getLabel(), (Object)right.getId());
        }
        HashMap<String, I18nizableText> widgetParameters = new HashMap<String, I18nizableText>();
        widgetParameters.put("emptyText", new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_RIGHT_FIELD_PLACEHOLDER"));
        rightsRecipient.setWidgetParameters(widgetParameters);
        rightsRecipient.setEnumerator((Enumerator)rightsStaticEnumerator);
        DataHolderRelativeDisableConditions rightDisableConditions = new DataHolderRelativeDisableConditions();
        DataHolderRelativeDisableCondition rightCondition = new DataHolderRelativeDisableCondition(this._getFunctionArgumentPrefix() + ARG_RECIPIENT, DisableCondition.OPERATOR.NEQ, __RIGHTS_RECIPIENT_ARG, this._disableConditionsHelper);
        rightDisableConditions.getConditions().add(rightCondition);
        rightsRecipient.setDisableConditions((DisableConditions)rightDisableConditions);
        rightsRecipient.setMultiple(true);
        return rightsRecipient;
    }

    private WorkflowArgument _getManualRecipientArgument() {
        WorkflowArgument manualRecipient = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_MANUAL_RECIPIENT, (I18nizableText)new I18nizableText(""), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_MANUAL_FIELD_DESCRIPTION"), (boolean)true, (boolean)false);
        manualRecipient.setDefaultValue((Object)"{user}");
        DataHolderRelativeDisableConditions manualDisableConditions = new DataHolderRelativeDisableConditions();
        DataHolderRelativeDisableCondition manualCondition = new DataHolderRelativeDisableCondition(this._getFunctionArgumentPrefix() + ARG_RECIPIENT, DisableCondition.OPERATOR.NEQ, __MANUAL_RECIPIENT_ARG, this._disableConditionsHelper);
        manualDisableConditions.getConditions().add(manualCondition);
        manualRecipient.setDisableConditions((DisableConditions)manualDisableConditions);
        HashMap<String, I18nizableText> widgetParameters = new HashMap<String, I18nizableText>();
        widgetParameters.put("emptyText", new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_MANUAL_FIELD_PLACEHOLDER"));
        manualRecipient.setWidgetParameters(widgetParameters);
        return manualRecipient;
    }

    protected String _getFunctionArgumentPrefix() {
        return FUNCTION_PARAM_PREFIX;
    }

    private WorkflowArgument _getRecipientTypeArgument() {
        StaticEnumerator recipientStaticEnumerator = new StaticEnumerator();
        recipientStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_USER_LABEL"), (Object)"user");
        recipientStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_GROUP_RIGHTS_LABEL"), (Object)__RIGHTS_RECIPIENT_ARG);
        recipientStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_USER_GROUP_LABEL"), (Object)__USER_GROUP_RECIPIENT_ARG);
        recipientStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_MANUAL_LABEL"), (Object)__MANUAL_RECIPIENT_ARG);
        WorkflowArgument recipient = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_RECIPIENT, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_RECIPIENT_DESCRIPTION"), (boolean)true, (boolean)false);
        recipient.setEnumerator((Enumerator)recipientStaticEnumerator);
        recipient.setDefaultValue((Object)"user");
        return recipient;
    }

    private WorkflowArgument _getSenderArgument() {
        WorkflowArgument sender = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_SENDER, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_SENDER_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_SENDER_DESCRIPTION"), (boolean)true, (boolean)false);
        sender.setDefaultValue(Config.getInstance().getValue("smtp.mail.from"));
        return sender;
    }

    private WorkflowArgument _getSubjectArgument() {
        WorkflowArgument subjectField = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_SUBJECT, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_SUBJECT_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_SUBJECT_DESCRIPTION"), (boolean)true, (boolean)false);
        subjectField.setDefaultValue((Object)this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_FUNCTION_DEFAULT_SUBJECT")));
        return subjectField;
    }

    private WorkflowArgument _getBodyArgument() {
        WorkflowArgument bodyField = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_BODY, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_BODY_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_BODY_DESCRIPTION"), (boolean)true, (boolean)false);
        bodyField.setWidget("edition.textarea");
        HashMap<String, I18nizableText> widgetParameters = new HashMap<String, I18nizableText>();
        widgetParameters.put("height", new I18nizableText("250"));
        bodyField.setWidgetParameters(widgetParameters);
        bodyField.setDefaultValue((Object)this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_FUNCTION_DEFAULT_BODY")));
        return bodyField;
    }

    private WorkflowArgument _getEntryDetailArgument() {
        StaticEnumerator dataStaticEnumerator = new StaticEnumerator();
        dataStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_NO_DATA_LABEL"), (Object)__NO_DATA);
        dataStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_WITH_RESTRICTION_LABEL"), (Object)__WITH_RESTRICTION);
        dataStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_WITHOUT_RESTRICTION_LABEL"), (Object)__WITHOUT_RESTRICTION);
        WorkflowArgument entryDetail = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_ENTRY_DETAIL, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_ENTRY_DETAILS_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_ENTRY_DETAILS_DESCRIPTION"), (boolean)false, (boolean)false);
        entryDetail.setEnumerator((Enumerator)dataStaticEnumerator);
        entryDetail.setDefaultValue((Object)__NO_DATA);
        HashMap<String, I18nizableText> extWidgetParameters = new HashMap<String, I18nizableText>();
        extWidgetParameters.put("naturalOrder", new I18nizableText("true"));
        entryDetail.setWidgetParameters(extWidgetParameters);
        return entryDetail;
    }

    private WorkflowArgument _getLinkArgument() {
        StaticEnumerator linkStaticEnumerator = new StaticEnumerator();
        linkStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_EMPTY_LABEL"), (Object)"");
        linkStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_DASHBOARD_LABEL"), (Object)__DASHBOARD);
        linkStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_SUBMISSIONS_LABEL"), (Object)__SUBMISSIONS);
        WorkflowArgument link = WorkflowElementDefinitionHelper.getElementDefinition((String)ARG_LINK, (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_LINK_LABEL"), (I18nizableText)new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_ARGUMENT_LINK_DESCRIPTION"), (boolean)false, (boolean)false);
        link.setEnumerator((Enumerator)linkStaticEnumerator);
        link.setDefaultValue((Object)"");
        return link;
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_FUNCTION_LABEL");
    }

    public List<WorkflowHelper.WorkflowVisibility> getVisibilities() {
        List visibilities = super.getVisibilities();
        visibilities.add(WorkflowHelper.WorkflowVisibility.USER);
        return visibilities;
    }
}

