<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    exclude-result-prefixes="ametys">

    <xsl:variable name="date-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_DATE_FORMAT',ametys:lang())"></xsl:variable>
    <xsl:variable name="date-time-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_DATE_TIME_FORMAT', ametys:lang())"></xsl:variable>
    
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
    <xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'"/>

    <xsl:variable name="cssPrefix">entry-form-fields</xsl:variable>
    
    <xsl:template match="/entry">
        <dl class="{$cssPrefix}">
            <xsl:apply-templates select="field"/>
        </dl>
    </xsl:template>
    
    <xsl:template match="field">
        <div class="{$cssPrefix}__item">
            <xsl:apply-templates select="." mode="display-label"/>   
            <xsl:apply-templates select="." mode="display-value"/>    
        </div>
    </xsl:template>
    
    <xsl:template match="field" mode="display-label">
        <dt class="{$cssPrefix}__item_label">
            <xsl:value-of select="@label"/>
        </dt>
    </xsl:template>
    
    <xsl:template match="field" mode="display-value">
        <dd class="{$cssPrefix}__item_value {translate(@type, $uppercase, $lowercase)}">
            <xsl:choose>
                <xsl:when test="text() != ''">
                    <xsl:apply-templates select="." mode="value"/>    
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_EMPTY_VALUE" i18n:catalogue="plugin.forms"/>
                </xsl:otherwise>
            </xsl:choose>
        </dd>
    </xsl:template>
    
    <xsl:template match="field[@type='FILE']" mode="value">
        <a href="{concat(ametys:siteUriPrefix(), '/_plugins/forms/', ../@siteName, '/download/', ../@formId, '/', ../@id, '/', @columnName, '/', .)}" ><xsl:value-of select="." /></a>
    </xsl:template>
    
    <xsl:template match="field[@type='TEXT' and @regexptype='datetime']" mode="value">
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{.}"/>
    </xsl:template>
    
    <xsl:template match="field[@type='TEXT' and @regexptype='date']" mode="value">
        <i18n:date src-pattern="yyyy-MM-dd" pattern="{$date-format}" value="{.}"/>
    </xsl:template>
    
    <xsl:template match="field[@type='CHECKBOX']" mode="value">
        <xsl:choose>
            <xsl:when test=". = 'true'">
                <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_BOOLEAN_TRUE" i18n:catalogue="plugin.forms"/>
            </xsl:when>
            <xsl:otherwise> <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_BOOLEAN_FALSE" i18n:catalogue="plugin.forms"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="field[@type='TEXTAREA']" mode="value">
        <xsl:call-template name="replaceBr">
            <xsl:with-param name="input" select="."/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="field" mode="value">
        <xsl:value-of select="."/>
    </xsl:template>
    
    <xsl:template name="replaceBr">
        <xsl:param name="input"/>
        <xsl:param name="s1"><xsl:text>
        </xsl:text></xsl:param>
        <xsl:choose>
            <xsl:when test="contains($input, $s1)">
                <xsl:variable name="rest">
                    <xsl:call-template name="replaceBr">
                        <xsl:with-param name="input" select="substring-after($input, $s1)"/>
                        <xsl:with-param name="s1" select="$s1"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:value-of select="substring-before($input, $s1)"/>
                <br/>
                <xsl:copy-of select="$rest"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$input"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
