<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl ametys resolver">
    
    <xsl:import href="service://pages/services/common/dashboard.xsl"/>
    <xsl:import href="workspace:web://stylesheets/variables.xsl"/>     
    <xsl:import href="view://stylesheets/utils.xsl"/>    
    
    <xsl:param name="uniqueId" />
    
    <xsl:template match="answers">
        <html>
            <body>
                <div data-dashboard="results">
                    <xsl:call-template name="results" />
                </div>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="results">
        <xsl:choose>
            <xsl:when test="count(answer) > 0">
                <xsl:call-template name="dashboard" />
            </xsl:when>
            <xsl:otherwise>
               <div class="no-answer">
                   <p><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_NO_ENTRY" i18n:catalogue="plugin.forms"/></p>
               </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
