/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a form entry.
 * @private
 */
Ext.define(
	"Ametys.plugins.forms.FormEntry", 
	{
		config: {
			/**
			 * @cfg {String} id The unique id of the form entry
			 */
			/**
			 * @method getId Get the #cfg-id
			 * @return {String} The id
			 */
			/** @ignore */
			id: null,
			/**
             * @cfg {String} formId The form id of the entry
             */
            /**
             * @method getFormId Get the #cfg-formId
             * @return {String} The form id of the entry
             */
            /** @ignore */
            formId: null,
            /**
             * @cfg {String[]} rights List of the id of the rights the current user have on this form entry
             */
            /**
             * @method getRights Get the #cfg-rights
             * @return {String[]} The rights
             */
            /** @ignore */
            rights: []
		},
		
		/**
		 * Creates a content instance
		 * @param {Object} config See configuration doc.
		 */
		constructor: function (config)
		{
			this.initConfig(config);
		},
		
		/**
		 * Get the form entry's properties
		 * @return {Object} initialProperty The initial form entry's properties
		 */
		getProperties: function (initialProperty)
		{
			initialProperty = initialProperty || {};
			
			return Ext.apply ({
					id: this._id,
                    formId: this._formId,
                    rights: this._rights
                }, initialProperty
			);
		}
	}
);
