/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 /**
 * This class controls the ribbon button to set workflow on form entries
 * @private
 */
Ext.define('Ametys.plugins.forms.controllers.MenuFormWorkflowController', {
    extend: 'Ametys.plugins.forms.controllers.FormController',

    updateState: function()
    {
        this.callParent(arguments);
        
        var target = this.getMatchingTargets()[0];
        if (target)
        {
            var id = this.getId();
            var workflowName = target.getParameters().workflowName;
            
            Ext.Array.each (this.getReferencedControllerIds(), function (controlId) {
                var elmt = Ametys.ribbon.RibbonManager.getUI(controlId);
                if (workflowName == null || workflowName == "")
                {
                    var buttonId = id + ".ametys_no_workflow";
                    elmt.toggle(controlId == buttonId);
                }
                else
                {
                    var buttonId = id + "." + workflowName;
                    elmt.toggle(controlId == buttonId);
                }
            });
        }
    }
});