<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="view:forms://stylesheets/forms/mail/form-entry.xsl"/>
    
    <xsl:param name="site-title" />
    <xsl:param name="site-url" />
    <xsl:param name="form-name" />
    
    <xsl:template match="/">
        <html>
            <body>
                <div>
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_FORMS_CONTENT_MAIL_RESULTS_TEXT_NO_HTML" i18n:catalogue="plugin.forms"/>
                        <i18n:param><xsl:value-of select="form-results/@label"/></i18n:param>
                    </i18n:translate>
                    
                    <xsl:value-of select="concat($nl, $nl)"/>
                    
                    <xsl:apply-templates select="form-results/entry" mode="text"/>
                </div>
            </body>
        </html>
    </xsl:template>
    
</xsl:stylesheet>
