/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.generators;

import java.util.List;
import java.util.Optional;

import org.ametys.plugins.forms.dao.FormQuestionDAO.FormEntryValues;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;

/**
 * Generate the entry of a form for the admin dashboard
 */
public class FormAdminEntryInformationGenerator extends FormEntryInformationGenerator
{
    @Override
    protected void _checkRights(FormEntry entry)
    {
        _formEntryDAO.checkHandleDataRight(entry);
    }
    
    @Override
    protected List<FormQuestion> _getQuestions(FormEntry entry, Optional<Long> currentStepId)
    {
        return _formQuestionDAO.getRuleFilteredQuestions(entry.getForm(), new FormEntryValues(null, entry), currentStepId, false, false);
    }
}
