/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.properties.section;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.properties.section.AbstractPropertySection;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightManager.RightResult;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.repository.AmetysObject;

/**
 * Section displaying values of the form entry.
 * This section has its own pipeline.
 */
public class FormEntryValuesSection extends AbstractPropertySection implements Serviceable
{
    /** The rights manager */
    protected RightManager _rightManager;
    
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        _rightManager = (RightManager) serviceManager.lookup(RightManager.ROLE);
    }
    
    @Override
    public boolean supports(AmetysObject ametysObject)
    {
        return ametysObject instanceof FormEntry entry && _rightManager.currentUserHasRight(FormEntryDAO.HANDLE_FORMS_ENTRIES_RIGHT_ID, entry) == RightResult.RIGHT_ALLOW;
    }
    
    public Map<String, Object> getParameters(AmetysObject ametysObject)
    {
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("entryId", ametysObject.getId());
        return resultMap;
    }

    public String getDataURL(AmetysObject ametysObject)
    {
        return "cocoon://_plugins/forms/form-entry-values-section";
    }
}
