/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.types;

import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewItem;

/**
 * Provide the necessary method make a form question type aware of confidentiality.
 * 
 * Every implementation should make sure that the result of the different provided method are used.
 * The value of FormQuestion.ATTRIBUTE_CONFIDENTIALITY should also be included in the result of the getFieldToDisableIfFormPublished method
 */
public interface ConfidentialAwareQuestionType
{
    /** Constant for confidentiality on field */
    public static final String ATTRIBUTE_CONFIDENTIALITY = "confidentiality";
    
    /**
     * Provide an item that should be included in the model returned by the FormQuestion._getModelItems method
     * @return the model item to include
     */
    public ModelItem getConfidentialityModelItem();
    
    /**
     * Provide a view item to include in one of the tab return by the FormQuestion.getTabs method.
     * It is preferred to include this item in the advanced tab.
     * @param model the model of the question type
     * @return the view item to include
     */
    public ViewItem getConfidentialityViewElement(Model model);

    /**
     * Check if the question is confidential
     * @param formQuestion the question
     * @return true if the question is confidential
     */
    public boolean isConfidential(FormQuestion formQuestion);
}
