/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.rights;

import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.group.GroupIdentity;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.right.ProfileAssignmentsToolClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.dao.FormDirectoryDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormDirectory;

/**
 * {@link ClientSideElement} for the tool displaying the profile assignments for forms
 */
public class FormsProfileAssignmentsToolClientSideElement extends ProfileAssignmentsToolClientSideElement
{
    /** The form DAO */
    private FormDAO _formDAO;
    
    /** The form directory DAO */
    private FormDirectoryDAO _formDirectoryDAO;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _formDAO = (FormDAO) smanager.lookup(FormDAO.ROLE);
        _formDirectoryDAO = (FormDirectoryDAO) smanager.lookup(FormDirectoryDAO.ROLE);
    }

    @Override
    protected boolean canDelegateRights(UserIdentity user, Set<GroupIdentity> groups, String profileId, String assignment , Object context)
    {
        // Any user having affectation rights on a form or a form directory should be able to affect profiles, even if he don't already have it
        if (context instanceof Form)
        {
            return _formDAO.hasRightAffectationRightOnForm(user, (Form) context);
        }
        else if (context instanceof FormDirectory)
        {
            return _formDirectoryDAO.hasRightAffectationRightOnFormDirectory(user, (FormDirectory) context);
        }
        return super.canDelegateRights(user, groups, profileId, assignment, context);
    }
}
