/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.ametys.core.util.DateUtils;

public final class FormDateUtils {
    private FormDateUtils() {
    }

    public static ZonedDateTime asZonedDateTime(LocalDate date) {
        return date.atStartOfDay(ZoneId.of("UTC"));
    }

    public static String zonedDateTimeToString(ZonedDateTime zonedDateTime) {
        return zonedDateTime.format(DateUtils.getISODateTimeFormatter());
    }

    public static ZonedDateTime parseZonedDateTime(String zonedDateTimeAsString) {
        return ZonedDateTime.parse(zonedDateTimeAsString, DateUtils.getISODateTimeFormatter());
    }
}

