/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.config.Config;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceUtil;
import org.xml.sax.SAXException;

public class FormEntryFileReader
extends ServiceableReader {
    private CurrentUserProvider _currentUserProvider;
    private SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeExtensionPoint;
    private RenderingContextHandler _renderingContextHandler;

    private SQLDatabaseTypeExtensionPoint getSQLDatabaseTypeExtensionPoint() {
        if (this._sqlDatabaseTypeExtensionPoint == null) {
            try {
                this._sqlDatabaseTypeExtensionPoint = (SQLDatabaseTypeExtensionPoint)this.manager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._sqlDatabaseTypeExtensionPoint;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._renderingContextHandler = (RenderingContextHandler)smanager.lookup(RenderingContextHandler.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection connection;
        block12: {
            String siteName = this.parameters.getParameter("site", "");
            String formId = this.parameters.getParameter("form-id", "");
            int entryId = this.parameters.getParameterAsInteger("entry-id", Integer.MIN_VALUE);
            String fieldId = this.parameters.getParameter("field-id", "");
            if (StringUtils.isEmpty((CharSequence)siteName) || StringUtils.isEmpty((CharSequence)formId) || entryId == Integer.MIN_VALUE || StringUtils.isEmpty((CharSequence)fieldId)) {
                throw new IllegalArgumentException("Site name, form id, entry id and field id must be provided.");
            }
            String tableName = "Forms_" + formId;
            connection = null;
            stmt = null;
            rs = null;
            try {
                String dataSourceId = (String)Config.getInstance().getValue("plugins.forms.datasource");
                connection = ConnectionHelper.getConnection((String)dataSourceId);
                String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
                String sql = "SELECT " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, fieldId) + ",login,populationId FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName) + " WHERE id = ?";
                stmt = connection.prepareStatement(sql);
                stmt.setInt(1, entryId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block12;
                String login = rs.getString("login");
                String population = rs.getString("populationId");
                this._checkAccess(login, population);
                try (InputStream is = this._sqlDatabaseTypeExtensionPoint.getBlob(dbType, rs, 1);){
                    if (is != null) {
                        SourceUtil.copy((InputStream)is, (OutputStream)this.out);
                    }
                }
            }
            catch (SQLException e) {
                try {
                    this.getLogger().error("Error reading a form entry blob." + tableName, (Throwable)e);
                    throw new ProcessingException("Error reading a form entry blob.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    ConnectionHelper.cleanup(rs);
                    ConnectionHelper.cleanup(stmt);
                    ConnectionHelper.cleanup((Connection)connection);
                    throw throwable;
                }
            }
        }
        ConnectionHelper.cleanup((ResultSet)rs);
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
    }

    private void _checkAccess(String login, String population) {
        RenderingContext context;
        UserIdentity entryOwner = null;
        if (StringUtils.isNotEmpty((CharSequence)login) && StringUtils.isNotEmpty((CharSequence)population)) {
            entryOwner = new UserIdentity(login, population);
        }
        if ((context = this._renderingContextHandler.getRenderingContext()) == RenderingContext.FRONT) {
            UserIdentity currentUser = this._currentUserProvider.getUser();
            if (entryOwner == null || !entryOwner.equals((Object)currentUser)) {
                throw new AccessDeniedException("User '" + String.valueOf(currentUser) + "' is not allowed to access to user entry data.");
            }
        }
    }
}

