/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class FormAdminDashboardHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FormAdminDashboardHelper.class.getName();
    protected WorkflowProvider _workflowProvider;
    protected FormDAO _formDAO;
    protected RightManager _rightManager;
    protected FormEntryDAO _formEntryDAO;
    protected WorkflowHelper _workflowHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._workflowProvider = (WorkflowProvider)manager.lookup(WorkflowProvider.ROLE);
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._formEntryDAO = (FormEntryDAO)((Object)manager.lookup(FormEntryDAO.ROLE));
        this._workflowHelper = (WorkflowHelper)manager.lookup(WorkflowHelper.ROLE);
    }

    public List<Form> getFormToAdmin(String siteName, UserIdentity currentUser) {
        return this._formDAO.getForms(siteName).stream().filter(Form::hasWorkflow).filter(f -> this._formEntryDAO.hasHandleDataRightOnForm(currentUser, (AmetysObject)f)).filter(f -> this._hasAtLeastOneEntryToDoAction((Form)((Object)f), currentUser)).toList();
    }

    protected boolean _hasAtLeastOneEntryToDoAction(Form form, UserIdentity user) {
        return form.getEntries().stream().filter(entry -> !entry.hasValue("anonymizationDate")).anyMatch(this::hasAvailableActions);
    }

    public boolean hasAvailableActions(FormEntry entry) {
        return this._getAvailableActions(entry).length > 0;
    }

    public List<ActionDescriptor> getAvailableActions(FormEntry entry, List<String> types) {
        ArrayList<ActionDescriptor> actions = new ArrayList<ActionDescriptor>();
        WorkflowDescriptor workflowDescriptor = this._workflowHelper.getWorkflowDescriptor(entry.getForm().getWorkflowName());
        for (int actionId : this._getAvailableActions(entry)) {
            ActionDescriptor action = workflowDescriptor.getAction(actionId);
            Map metaAttributes = action.getMetaAttributes();
            String actionType = metaAttributes.getOrDefault("action-type", "");
            if (!types.isEmpty() && !types.contains(actionType)) continue;
            actions.add(action);
        }
        return actions;
    }

    private int[] _getAvailableActions(FormEntry entry) {
        HashMap<String, FormEntry> inputs = new HashMap<String, FormEntry>();
        inputs.put(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY, entry);
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)entry);
        return workflow.getAvailableActions(entry.getWorkflowId(), inputs);
    }
}

