/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.ametys.runtime.plugin.component.LazyInitializeExtensions;
import org.apache.commons.io.IOUtils;

@LazyInitializeExtensions
public class FormQuestionTypeExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<FormQuestionType> {
    public static final String ROLE = FormQuestionTypeExtensionPoint.class.getName();
    private String _questions2htmlXSLT;

    public String getQuestionsXSLTForHTML() {
        return this._questions2htmlXSLT;
    }

    public void initializeExtensions() throws Exception {
        String template = this._readTemplate();
        Set<String> questions2htmlXSLTs = this._getQuestions2htmlXSLTs();
        String questions2htmlXSLTsIncludes = this._createIncludes(questions2htmlXSLTs);
        this._questions2htmlXSLT = template.replace("@INCLUDE@", questions2htmlXSLTsIncludes);
    }

    private String _readTemplate() throws IOException {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("template.xsl");){
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
    }

    private String _createIncludes(Set<String> includes) {
        StringBuffer sb = new StringBuffer("");
        for (String file : includes) {
            sb.append("<xsl:include href=\"");
            sb.append(file);
            sb.append("\"/>");
        }
        return sb.toString();
    }

    private Set<String> _getQuestions2htmlXSLTs() {
        return this.getExtensionsIds().stream().map(arg_0 -> ((FormQuestionTypeExtensionPoint)this).getExtension(arg_0)).map(FormQuestionType::getDisplayXSLTs).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

