/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.schedulable;

import java.time.Period;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.BooleanExpression;
import org.ametys.plugins.repository.query.expression.DateExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.MetadataExpression;
import org.ametys.plugins.repository.query.expression.NotExpression;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobExecutionContext;

public class FormEntriesExpirationSchedulable
extends AbstractStaticSchedulable {
    private AmetysObjectResolver _resolver;
    private FormEntryDAO _formEntryDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._formEntryDAO = (FormEntryDAO)((Object)manager.lookup(FormEntryDAO.ROLE));
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        String query = QueryHelper.getXPathQuery(null, (String)"ametys:form", (Expression)new BooleanExpression("expirationEnabled", true));
        try (AmetysObjectIterable queryResult = this._resolver.query(query);){
            for (Form form : queryResult) {
                Form.ExpirationPolicy policy = form.getExpirationPolicy();
                ZonedDateTime expirationLimit = ZonedDateTime.now().minus(Period.ofMonths((int)form.getExpirationPeriod()));
                DateExpression dateExpr = new DateExpression("ametys-submit-date", Expression.Operator.LT, expirationLimit);
                Object expiredExpr = policy == Form.ExpirationPolicy.ANONYMIZE ? new AndExpression(new Expression[]{dateExpr, new NotExpression((Expression)new MetadataExpression("anonymizationDate"))}) : dateExpr;
                List<FormEntry> entries = this._formEntryDAO.getFormEntries(form, false, (Expression)expiredExpr, List.of());
                if (entries.isEmpty()) continue;
                for (FormEntry entry : entries) {
                    switch (policy) {
                        case DELETE: {
                            entry.remove();
                            break;
                        }
                        case ANONYMIZE: {
                            entry.anonymize();
                            break;
                        }
                        default: {
                            this.getLogger().error("Unsupported expiration policy '{}' for form '{}'. Action is ignored", (Object)policy, (Object)form.getId());
                        }
                    }
                    entry.saveChanges();
                }
                String category = switch (policy) {
                    case Form.ExpirationPolicy.DELETE -> "data.policy.gdpr.remove.form.submissions.expiration";
                    case Form.ExpirationPolicy.ANONYMIZE -> "data.policy.gdpr.anonymize.form.submissions.expiration";
                    default -> "data.policy.gdpr.form.submissions.expiration";
                };
                ForensicLogger.info((String)category, Map.of("handled", Long.toString(entries.size()), "form", form.getId(), "formTitle", form.getTitle()), (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY);
            }
        }
    }
}

